/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.config.filter;

import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.config.filter.FilterReason;
import com.nine.travelerscompass.config.filter.FilterType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class FilterManager {
    private static final Map<class_1792, FilterReason> FILTER_CACHE = new HashMap<class_1792, FilterReason>();
    private static final Map<class_2960, FilterReason> FILTER_ENTITIES_CACHE = new HashMap<class_2960, FilterReason>();
    public static FilterData filterData;

    public static FilterReason getFilterReason(class_1299<?> type) {
        if (type == null) {
            return new FilterReason.Allowed();
        }
        class_2960 location = class_7923.field_41177.method_10221(type);
        FilterReason answer = FILTER_ENTITIES_CACHE.get(location);
        if (answer == null) {
            boolean inList = FilterManager.filterData.entitiesFilterSet.contains(location);
            answer = FilterManager.filterData.entitiesFilterType == FilterType.BLACKLIST && inList || FilterManager.filterData.entitiesFilterType == FilterType.WHITELIST && !inList ? new FilterReason.ByEntityType(type) : new FilterReason.Allowed();
            FILTER_ENTITIES_CACHE.put(location, answer);
        }
        return answer;
    }

    public static FilterReason getFilterReason(class_1792 item) {
        if (item == class_1802.field_8162) {
            return new FilterReason.Allowed();
        }
        FilterReason answer = FILTER_CACHE.get(item);
        if (answer == null) {
            answer = FilterManager.computeItemFilterReason(item);
            FILTER_CACHE.put(item, answer);
        }
        return answer;
    }

    private static FilterReason computeItemFilterReason(class_1792 item) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        String modId = itemId.method_12836();
        boolean modMatch = FilterManager.filterData.modsFilterSet.contains(modId);
        if (FilterManager.filterData.modsFilterType == FilterType.BLACKLIST && modMatch) {
            return new FilterReason.ByModId(modId);
        }
        if (FilterManager.filterData.modsFilterType == FilterType.WHITELIST && !modMatch) {
            return new FilterReason.ByModId(modId);
        }
        boolean itemMatch = FilterManager.filterData.itemsFilterSet.contains(itemId);
        if (FilterManager.filterData.itemsFilterType == FilterType.BLACKLIST && itemMatch) {
            return new FilterReason.ByItemId(itemId);
        }
        if (FilterManager.filterData.itemsFilterType == FilterType.WHITELIST && !itemMatch) {
            return new FilterReason.ByItemId(itemId);
        }
        boolean hasWhitelistedTag = false;
        for (class_6862<class_1792> tag : FilterManager.filterData.tagsFilterSet) {
            boolean hasTag = item.method_40131().method_40220(tag);
            if (FilterManager.filterData.tagsFilterType == FilterType.BLACKLIST && hasTag) {
                return new FilterReason.ByTag(tag);
            }
            if (!hasTag) continue;
            hasWhitelistedTag = true;
        }
        if (FilterManager.filterData.tagsFilterType == FilterType.WHITELIST && !hasWhitelistedTag) {
            return new FilterReason.ByTag(FilterManager.filterData.tagsFilterSet.iterator().next());
        }
        return new FilterReason.Allowed();
    }

    public static void reload() {
        FILTER_CACHE.clear();
        FILTER_ENTITIES_CACHE.clear();
        filterData = new FilterData(TCConfig.MODS_FILTER_TYPE.get(), new HashSet<String>((Collection)TCConfig.MODS_FILTER.get()), TCConfig.ITEM_TAGS_FILTER_TYPE.get(), TCConfig.ITEM_TAGS_FILTER.get().stream().map(s -> class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)s))).collect(Collectors.toSet()), TCConfig.ITEMS_FILTER_TYPE.get(), TCConfig.ITEMS_FILTER.get().stream().map(class_2960::method_60654).collect(Collectors.toSet()), TCConfig.ENTITIES_FILTER_TYPE.get(), TCConfig.ENTITIES_FILTER.get().stream().map(class_2960::method_60654).collect(Collectors.toSet()));
    }

    public static boolean passesFilters(class_1799 stack) {
        if (stack.method_7960() || stack.method_7909() instanceof TravelersCompassItem) {
            return false;
        }
        return FilterManager.getFilterReason(stack.method_7909()) instanceof FilterReason.Allowed;
    }

    public record FilterData(FilterType modsFilterType, Set<String> modsFilterSet, FilterType tagsFilterType, Set<class_6862<class_1792>> tagsFilterSet, FilterType itemsFilterType, Set<class_2960> itemsFilterSet, FilterType entitiesFilterType, Set<class_2960> entitiesFilterSet) {
    }
}

