/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientCache;
import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.base.BaseIconButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.client.utils.SearchProgress;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.utils.FoundBlockPos;
import com.nine.travelerscompass.common.utils.SearchState;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class InfoButton
extends BaseIconButton {
    private final UUID uuid = CompassProperties.COMPASS_UUID.get(this.stack());

    public InfoButton(ButtonGenericSettings settings) {
        super(settings);
        this.refreshTooltip();
    }

    @Override
    protected TextureData getMainLayerTexture() {
        return this.buttonTexturesSet().get(false, this.field_22762);
    }

    @Override
    protected Icon getIcon() {
        return this.field_22762 ? CompassUI.CommonTextures.INFO_HOVERED_ICON : CompassUI.CommonTextures.INFO_ICON;
    }

    @Override
    public void refreshTooltip() {
        class_5250 status;
        TooltipBuilder builder = TooltipBuilder.builder();
        class_5250 title = class_2561.method_43471((String)"tooltip.travelerscompass.settings.info");
        FoundBlockPos pos = CompassProperties.FOUND_BLOCK_POS.get(this.stack());
        SearchState state = CompassProperties.SEARCH_STATE.get(this.stack());
        if (CompassProperties.PAUSE.get(this.stack()).booleanValue()) {
            status = class_2561.method_43471((String)"tooltip.travelerscompass.settings.info.status.paused").method_27692(class_124.field_1080);
        } else if (state == SearchState.SEARCHING) {
            SearchProgress searchProgress = ClientCache.PROGRESS_DATA_CACHE.get(this.uuid);
            int percent = 0;
            if (searchProgress != null) {
                percent = searchProgress.progress * 100 / searchProgress.total;
            }
            class_5250 progress = ClientUtils.coloredComponent(class_2561.method_43470((String)(percent + "%")), 0xC8C8C8);
            status = pos.isValid() ? class_2561.method_43469((String)"tooltip.travelerscompass.settings.info.status.scanning", (Object[])new Object[]{progress}).method_27692(class_124.field_1080) : class_2561.method_43469((String)"tooltip.travelerscompass.settings.info.status.searching", (Object[])new Object[]{progress}).method_27692(class_124.field_1080);
        } else {
            status = class_2561.method_43471((String)"tooltip.travelerscompass.settings.info.status.idle").method_27692(class_124.field_1080);
        }
        HudData data = ClientCache.HUD_DATA_CACHE.get(CompassProperties.COMPASS_UUID.get(this.stack()));
        if (data != null) {
            ILocationObject locationObject = data.getLocationObject();
            if (pos.isValid() && locationObject != null) {
                class_5250 target = class_2561.method_43469((String)"tooltip.travelerscompass.settings.info.target", (Object[])new Object[]{class_2561.method_43471((String)locationObject.descriptionId()).method_27692(class_124.field_1080)}).method_27692(class_124.field_1068);
                builder.line((class_2561)target);
                class_2338 blockPos = pos.blockPos();
                if (blockPos != null) {
                    class_5250 position = class_2561.method_43469((String)"tooltip.travelerscompass.settings.info.position", (Object[])new Object[]{class_2561.method_43470((String)(blockPos.method_10263() + ", " + blockPos.method_10264() + ", " + blockPos.method_10260())).method_27692(class_124.field_1080)}).method_27692(class_124.field_1068);
                    builder.line((class_2561)position);
                }
            }
        }
        builder.title((class_2561)title);
        builder.line((class_2561)class_2561.method_43469((String)"tooltip.travelerscompass.settings.info.status", (Object[])new Object[]{status}));
        this.method_47400(builder.buildAsTooltip());
    }

    @Override
    public void tick() {
        this.refreshTooltip();
    }
}

