/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientCache;
import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.base.BaseIconButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.client.utils.SearchProgress;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.utils.SearchState;
import com.nine.travelerscompass.network.packet.c2s.PausePacket;
import com.nine.travelerscompass.network.packet.c2s.WideSearchPacket;
import com.nine.travelerscompass.platform.Platform;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class WideSearchButton
extends BaseIconButton {
    public WideSearchButton(ButtonGenericSettings settings) {
        super(settings);
        this.refreshTooltip();
    }

    @Override
    public boolean onLeftClick(double mouseX, double mouseY) {
        if (CompassProperties.SEARCH_STATE.get(this.stack()) == SearchState.WIDE_SEARCHING) {
            if (this.shiftPressed) {
                ClientCache.PROGRESS_DATA_CACHE.put(this.uuid, new SearchProgress(0, 0));
                ClientCache.PROGRESS_DATA_CACHE.remove(this.uuid);
                Platform.PLATFORM_NETWORK.sendToServer(new PausePacket(this.uuid));
                CompassProperties.SEARCH_STATE.set(this.stack(), SearchState.IDLE);
            }
        } else {
            Platform.PLATFORM_NETWORK.sendToServer(new WideSearchPacket(this.uuid));
        }
        return true;
    }

    @Override
    protected TextureData getMainLayerTexture() {
        return CompassUI.ButtonTextures.TOGGLE_BUTTON.get(false, this.field_22762);
    }

    @Override
    protected Icon getIcon() {
        return this.field_22762 ? CompassUI.CommonTextures.WIDE_SEARCH_HOVERED_ICON : CompassUI.CommonTextures.WIDE_SEARCH_ICON;
    }

    @Override
    public void tick() {
        this.refreshTooltip();
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
        SearchProgress searchProgress = ClientCache.PROGRESS_DATA_CACHE.get(this.uuid);
        if (searchProgress != null && CompassProperties.SEARCH_STATE.get(this.stack()) == SearchState.WIDE_SEARCHING) {
            float progress = (float)searchProgress.progress / (float)searchProgress.total;
            this.drawProgress(graphics, this.method_46426() + 1, this.method_46427() + 12, 13, 1, progress, this.field_22762 ? -1 : -1560281089);
        }
    }

    private void drawProgress(class_332 g, int x, int y, int w, int h, float p, int fg) {
        float wf = p * (float)w;
        int full = class_3532.method_15375((float)wf);
        if (full > 0) {
            g.method_25294(x, y, x + full, y + h, fg);
        }
    }

    @Override
    public void refreshTooltip() {
        TooltipBuilder builder = TooltipBuilder.builder();
        String key = "tooltip.travelerscompass.wide_search";
        builder.title(key);
        builder.descIf(key, this.shiftPressed);
        if (CompassProperties.SEARCH_STATE.get(this.stack()) == SearchState.WIDE_SEARCHING) {
            SearchProgress searchProgress = ClientCache.PROGRESS_DATA_CACHE.get(this.uuid);
            int percent = 0;
            if (searchProgress != null) {
                percent = searchProgress.progress * 100 / searchProgress.total;
            }
            class_5250 progress = ClientUtils.coloredComponent(class_2561.method_43470((String)(percent + "%")), 0xC8C8C8);
            class_5250 shiftRBM = ClientUtils.coloredComponent(class_2561.method_43471((String)"tooltip.travelerscompass.settings.modification.shift_click"), 0xC8C8C8);
            builder.line((class_2561)class_2561.method_43469((String)"tooltip.travelerscompass.settings.info.status.progress", (Object[])new Object[]{progress}).method_27692(class_124.field_1080));
            builder.line((class_2561)class_2561.method_43469((String)"tooltip.travelerscompass.wide_search.cancel", (Object[])new Object[]{shiftRBM}).method_27692(class_124.field_1080));
        }
        this.method_47400(builder.buildAsTooltip());
    }
}

