/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button.base;

import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6880;

public abstract class BaseButton
extends class_4185 {
    protected boolean shiftPressed = false;
    protected boolean ctrlPressed = false;
    protected boolean hoverFlag = false;
    protected final Supplier<class_1799> stackSupplier;
    private final Consumer<BaseButton> onLeftClick;
    private final Consumer<BaseButton> onRightClick;
    private final Consumer<BaseButton> afterInteraction;
    protected final UUID uuid;

    public BaseButton(ButtonGenericSettings settings) {
        super(settings.x, settings.y, settings.width, settings.height, (class_2561)class_2561.method_43473(), b -> {}, field_40754);
        this.stackSupplier = settings.supplier;
        this.onLeftClick = settings.afterLeftClick;
        this.onRightClick = settings.afterRightClick;
        this.afterInteraction = settings.afterInteraction;
        this.uuid = settings.uuid;
    }

    public class_1799 stack() {
        return this.stackSupplier.get();
    }

    public Supplier<class_1799> stackSupplier() {
        return this.stackSupplier;
    }

    protected void onKeyModifierChanged() {
        this.refreshTooltip();
    }

    public void refreshTooltip() {
    }

    public void updateState() {
    }

    protected void onEnter() {
        this.updateState();
        this.refreshTooltip();
    }

    protected void onExit() {
    }

    public void tick() {
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!(this.field_22763 && this.field_22764 && this.method_25405(mouseX, mouseY))) {
            return false;
        }
        boolean handled = this.onMouseScroll(mouseX, mouseY, scrollX, scrollY);
        if (handled) {
            this.playMouseScrollSound(class_310.method_1551().method_1483(), scrollX, scrollY);
            this.updateState();
            this.refreshTooltip();
            if (this.afterInteraction != null) {
                this.afterInteraction.accept(this);
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public final boolean method_25402(double mouseX, double mouseY, int button) {
        if (!(this.field_22763 && this.field_22764 && this.method_25405(mouseX, mouseY))) {
            return false;
        }
        boolean handled = false;
        if (button == 0) {
            handled = this.onLeftClick(mouseX, mouseY);
            if (this.onLeftClick != null) {
                this.onLeftClick.accept(this);
                handled = true;
            }
        } else if (button == 1) {
            handled = this.onRightClick(mouseX, mouseY);
            if (this.onRightClick != null) {
                this.onRightClick.accept(this);
                handled = true;
            }
        }
        if (handled) {
            this.method_25354(class_310.method_1551().method_1483());
            this.updateState();
            this.refreshTooltip();
            if (this.afterInteraction != null) {
                this.afterInteraction.accept(this);
            }
            return true;
        }
        return false;
    }

    public void playMouseScrollSound(class_1144 soundManager, double scrollX, double scrollY) {
        soundManager.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        return false;
    }

    public boolean onRightClick(double mouseX, double mouseY) {
        return false;
    }

    public boolean onLeftClick(double mouseX, double mouseY) {
        return false;
    }

    protected boolean method_25351(int button) {
        return button == 0 || button == 1;
    }

    public final void method_25348(double mouseX, double mouseY) {
        this.onLeftClick(mouseX, mouseY);
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        boolean shiftDown = class_437.method_25442();
        boolean ctrlDown = class_437.method_25441();
        if (shiftDown != this.shiftPressed || ctrlDown != this.ctrlPressed) {
            this.ctrlPressed = ctrlDown;
            this.shiftPressed = shiftDown;
            this.onKeyModifierChanged();
        }
        if (this.method_49606()) {
            if (!this.hoverFlag) {
                this.hoverFlag = true;
                this.refreshTooltip();
                this.onEnter();
            }
        } else if (this.hoverFlag) {
            this.hoverFlag = false;
            this.onExit();
        }
    }
}

