/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button.popup;

import com.nine.travelerscompass.client.component.button.base.BaseButton;
import com.nine.travelerscompass.client.component.button.base.BaseIconButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconLayer;
import com.nine.travelerscompass.client.utils.TextureData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_768;

public abstract class PopupButton
extends BaseIconButton {
    protected final IconLayer popupLayer;
    protected final IconLayer connectorLayer;
    protected final class_768 popupRect;
    private boolean popupVisible = false;
    public List<BaseButton> popupButtons = new ArrayList<BaseButton>();
    private static final int POPUP_PADDING = 1;

    protected PopupButton(ButtonGenericSettings settings, IconLayer popupLayer, IconLayer connectorLayer) {
        super(settings);
        this.popupLayer = popupLayer;
        this.connectorLayer = connectorLayer;
        this.popupRect = this.calculatePopupRect(this.popupLayer);
    }

    protected class_768 calculatePopupRect(IconLayer popupTexture) {
        TextureData textureData = popupTexture.textureData();
        int x = (int)((float)this.method_46426() + popupTexture.xOffset() - 1.0f);
        int y = (int)((float)this.method_46427() + popupTexture.yOffset() - 1.0f);
        int width = textureData.width() + 1;
        int height = textureData.height() + 1;
        return new class_768(x, y, width, height);
    }

    public boolean isPopupVisible() {
        return this.popupVisible;
    }

    public void onPopupClosed() {
    }

    public void onPopupOpened() {
    }

    public void popupMouseClicked(double mouseX, double mouseY, int button) {
        int mX = (int)mouseX;
        int mY = (int)mouseY;
        if (this.isPopupVisible() && this.popupRect.method_3318(mX, mY)) {
            for (BaseButton popupElement : this.popupButtons) {
                popupElement.method_25402(mX, mY, button);
            }
        }
    }

    public void updatePopupButtons() {
        for (BaseButton b : this.popupButtons) {
            b.updateState();
        }
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        int mX = (int)mouseX;
        int mY = (int)mouseY;
        if (this.isPopupVisible() && this.popupRect.method_3318(mX, mY)) {
            for (BaseButton popupElement : this.popupButtons) {
                popupElement.method_25401(mouseX, mouseY, scrollX, scrollY);
            }
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public void afterPopupClick() {
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
        if (this.field_22762) {
            if (!this.popupVisible) {
                this.onPopupOpened();
            }
            this.popupVisible = true;
        } else if (this.popupVisible && !this.popupRect.method_3318(mouseX, mouseY)) {
            this.onPopupClosed();
            this.popupVisible = false;
        }
        if (this.isPopupVisible()) {
            this.renderPopup(graphics, mouseX, mouseY, partialTicks);
            for (BaseButton button : this.popupButtons) {
                button.method_25394(graphics, mouseX, mouseY, partialTicks);
            }
        }
    }

    protected void renderPopup(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        ClientUtils.renderIconLayer(graphics, this.popupLayer, this.method_46426(), this.method_46427());
        ClientUtils.renderIconLayer(graphics, this.connectorLayer, this.method_46426(), this.method_46427());
    }
}

