/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button.range;

import com.nine.travelerscompass.client.component.button.base.BaseIconButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonRangeSettings;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.client.utils.RangeIconVariants;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.Objects;
import java.util.function.DoubleFunction;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;

public class RangeButton<T extends Number>
extends BaseIconButton {
    public T cached;
    protected boolean outOfBounds = false;
    private final Icon icon;
    private final RangeIconVariants plusIcons;
    private final RangeIconVariants minusIcons;
    protected final DataStorage<T> data;
    private final T min;
    private final T max;
    private final T step;
    private final T ctrlStep;
    private final DoubleFunction<T> fromDouble;

    public RangeButton(ButtonRangeSettings settings, T minValue, T maxValue, T step, T ctrlStep, DoubleFunction<T> fromDouble, DataStorage<T> data) {
        super(settings);
        this.data = data;
        this.fromDouble = fromDouble;
        this.min = minValue;
        this.max = maxValue;
        this.step = step;
        this.ctrlStep = ctrlStep;
        this.icon = settings.icon;
        this.plusIcons = settings.plusIcons;
        this.minusIcons = settings.minusIcons;
        this.updateState();
    }

    protected T min() {
        return this.min;
    }

    protected T max() {
        return this.max;
    }

    protected boolean set(T value) {
        if (!Objects.equals(this.cached, value = this.clamp(value))) {
            this.onValueChanged(this.cached, value);
            return true;
        }
        return false;
    }

    protected void onValueChanged(T oldValue, T newValue) {
        this.data.syncToServer(this.stack(), newValue);
    }

    public final boolean isOutOfBounds(double v) {
        return Double.isNaN(v) || v < ((Number)this.min()).doubleValue() || v > ((Number)this.max()).doubleValue();
    }

    private T clamp(T value) {
        double v = ((Number)value).doubleValue();
        double minVal = ((Number)this.min()).doubleValue();
        double maxVal = ((Number)this.max()).doubleValue();
        if (v < minVal) {
            return this.min();
        }
        if (v > maxVal) {
            return this.max();
        }
        return value;
    }

    protected class_2561 holdToDecreaseComponent() {
        class_5250 shift = ClientUtils.coloredComponent(class_2561.method_43471((String)"tooltip.travelerscompass.settings.modification.shift"), this.shiftPressed ? 0xAAAAAA : 0xC8C8C8);
        return class_2561.method_43469((String)"tooltip.travelerscompass.settings.modification.hold_to_decrease", (Object[])new Object[]{shift}).method_27692(class_124.field_1080);
    }

    protected class_2561 holdToChangeFaster() {
        class_5250 ctrl = ClientUtils.coloredComponent(class_2561.method_43471((String)"tooltip.travelerscompass.settings.modification.ctrl"), this.ctrlPressed ? 0xAAAAAA : 0xC8C8C8);
        return class_2561.method_43469((String)"tooltip.travelerscompass.settings.modification.hold_to_change_faster", (Object[])new Object[]{ctrl}).method_27692(class_124.field_1080);
    }

    public void updateCache() {
        this.cached = (Number)this.data.get(this.stack());
    }

    @Override
    protected void onKeyModifierChanged() {
        super.onKeyModifierChanged();
        this.updateState();
    }

    @Override
    public void updateState() {
        this.updateCache();
        this.outOfBounds = this.isOutOfBounds(((Number)this.cached).doubleValue() + (double)(this.shiftPressed ? -1 : 1) * ((Number)(this.ctrlPressed ? this.ctrlStep : this.step)).doubleValue());
    }

    @Override
    public boolean onMouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.set((Number)this.fromDouble.apply(((Number)this.cached).doubleValue() + (double)(scrollY < 0.0 ? -1 : 1) * ((Number)(this.ctrlPressed ? this.ctrlStep : this.step)).doubleValue()));
    }

    @Override
    public boolean onLeftClick(double mouseX, double mouseY) {
        return this.set((Number)this.fromDouble.apply(((Number)this.cached).doubleValue() + (double)(this.shiftPressed ? -1 : 1) * ((Number)(this.ctrlPressed ? this.ctrlStep : this.step)).doubleValue()));
    }

    @Override
    public void playMouseScrollSound(class_1144 soundManager, double scrollX, double scrollY) {
        soundManager.method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_15015.comp_349()), (float)1.05f, (float)0.12f));
    }

    @Override
    protected TextureData getMainLayerTexture() {
        return this.buttonTexturesSet().get(false, this.field_22762, !this.outOfBounds || !this.field_22762);
    }

    @Override
    protected Icon getIcon() {
        Icon ret = this.field_22762 ? (this.shiftPressed ? this.minusIcons.get(this.ctrlPressed, !this.outOfBounds) : this.plusIcons.get(this.ctrlPressed, !this.outOfBounds)) : this.icon;
        return ret;
    }

    public String cachedAsString() {
        return String.valueOf(this.cached);
    }

    @Override
    public void refreshTooltip() {
        TooltipBuilder builder = TooltipBuilder.builder();
        String key = "tooltip.travelerscompass.settings." + this.data.id();
        builder.title(key);
        builder.line(this.holdToDecreaseComponent());
        builder.line(this.holdToChangeFaster());
        builder.descIf(key, this.shiftPressed);
        class_5250 value = class_2561.method_43470((String)String.valueOf(this.cachedAsString())).method_54663(0xC8C8C8);
        builder.state((class_2561)class_2561.method_43469((String)(key + ".value"), (Object[])new Object[]{value}).method_27692(class_124.field_1080));
        this.method_47400(builder.buildAsTooltip());
    }
}

