/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button.search;

import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.base.ToggleableButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import com.nine.travelerscompass.compat.lootr.LootrSearchMode;
import com.nine.travelerscompass.config.TCConfig;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class LootrSearchModeButton
extends ToggleableButton {
    private final DataStorage<LootrSearchMode> data = CompassProperties.LOOTR_MODE;
    private final boolean configEnabled;
    private LootrSearchMode cached;

    public LootrSearchModeButton(ButtonGenericSettings settings) {
        super(settings);
        this.field_22763 = this.configEnabled = TCConfig.ENABLE_LOOTR_SEARCH.get().booleanValue();
        this.updateState();
        this.refreshTooltip();
    }

    @Override
    public boolean onLeftClick(double mouseX, double mouseY) {
        CompassProperties.toggleToServer(this.stack(), this.data, true);
        return true;
    }

    @Override
    public void updateState() {
        this.cached = this.data.get(this.stack());
        this.setToggled(this.cached != LootrSearchMode.OFF);
        this.refreshTooltip();
    }

    @Override
    protected TextureData getMainLayerTexture() {
        return this.buttonTexturesSet().get(this.isToggled(), this.field_22762, this.configEnabled);
    }

    @Override
    protected Icon getIcon() {
        Icon ret;
        if (this.configEnabled) {
            ret = switch (this.cached) {
                default -> throw new MatchException(null, null);
                case LootrSearchMode.ALL -> CompassUI.SearchModeTextures.LOOTR_ALL_ICON;
                case LootrSearchMode.CLOSED -> CompassUI.SearchModeTextures.LOOTR_CLOSED_ICON;
                case LootrSearchMode.OPENED -> CompassUI.SearchModeTextures.LOOTR_OPENED_ICON;
                case LootrSearchMode.OFF -> CompassUI.SearchModeTextures.LOOTR_INACTIVE_ICON;
            };
        } else {
            ret = CompassUI.CommonTextures.LOCK_ICON;
        }
        return ret;
    }

    @Override
    public void refreshTooltip() {
        String key = "tooltip.travelerscompass.search_mode." + this.data.id();
        String withState = key + "." + this.cached.key();
        class_5250 desc = class_2561.method_43471((String)(withState + ".desc")).method_27692(class_124.field_1080);
        class_5250 state = class_2561.method_43471((String)withState).method_27692(class_124.field_1080);
        this.method_47400(TooltipBuilder.builder().title(key).descIf((class_2561)desc, this.shiftPressed).state((class_2561)state).buildAsTooltip());
    }
}

