/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.hud;

import com.nine.travelerscompass.client.ClientCache;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.hud.HudRenderMode;
import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.client.hud.anchor.HudAnchorX;
import com.nine.travelerscompass.client.hud.anchor.HudAnchorY;
import com.nine.travelerscompass.client.hud.type.IHudTypeRenderer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.init.ItemRegistry;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.class_10799;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_408;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import net.minecraft.class_9848;

public class HudRenderer {
    public static final class_2960 EDGES_TEXTURE = class_2960.method_60655((String)"travelerscompass", (String)"textures/gui/hud_edges.png");
    private static final int EDGE_PADDING = 7;
    private static final int HEIGHT_PADDING = 2;
    private static final int WIDTH_PADDING = 2;
    static final class_310 minecraft = class_310.method_1551();
    private static int renderTicksCount = 0;

    public static void renderTick(class_332 guiGraphics, class_9779 deltaTracker) {
        HudRenderer.renderTick(guiGraphics, deltaTracker.method_60637(false));
    }

    public static void renderTick(class_332 graphics, float partialTicks) {
        class_746 player = HudRenderer.minecraft.field_1724;
        if (player != null) {
            if (player.field_6012 % 100 == 0) {
                HashSet<UUID> validUUIDs = new HashSet<UUID>();
                for (class_1799 stack : player.method_31548().method_67533()) {
                    if (!stack.method_31574((class_1792)ItemRegistry.TRAVELERS_COMPASS.get())) continue;
                    UUID uuid2 = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
                    validUUIDs.add(uuid2);
                }
                ClientCache.HUD_DATA_CACHE.keySet().removeIf(uuid -> !validUUIDs.contains(uuid));
            }
            if (!HudRenderer.shouldShow()) {
                return;
            }
            for (HudData hudData : ClientCache.HUD_DATA_CACHE.values()) {
                HudSettings settings = hudData.getSettings();
                if (settings.renderMode() == HudRenderMode.OFF || settings.renderMode() == HudRenderMode.HAND_ONLY && !hudData.isSelected() || HudRenderer.minecraft.field_1755 instanceof class_408 && !settings.hudWithChat() || HudRenderer.minecraft.field_1755 != null && !(HudRenderer.minecraft.field_1755 instanceof class_408)) continue;
                HudRenderer.renderHud(graphics, hudData, false, partialTicks);
            }
        }
        if (player != null && renderTicksCount % 3000 == 0) {
            renderTicksCount = 0;
        }
    }

    public static void forceRender(class_332 graphics, float partialTicks, UUID uuid) {
        if (ClientCache.HUD_DATA_CACHE.containsKey(uuid)) {
            HudRenderer.renderHud(graphics, ClientCache.HUD_DATA_CACHE.get(uuid), true, partialTicks);
        }
    }

    private static void renderHud(class_332 graphics, HudData hudData, boolean drawEdges, float partialTicks) {
        float off;
        HudSettings settings = hudData.getSettings();
        IHudTypeRenderer renderer = settings.hudType().renderer;
        int scaledScreenWidth = minecraft.method_22683().method_4486();
        int scaledScreenHeight = minecraft.method_22683().method_4502();
        int x = Math.min(settings.xPos(), scaledScreenWidth);
        int y = Math.min(settings.yPos(), scaledScreenHeight);
        int width = Math.min(scaledScreenWidth, settings.width());
        int height = Math.min(scaledScreenHeight, settings.height());
        graphics.method_51448().pushMatrix();
        if (settings.anchorX() == HudAnchorX.RIGHT) {
            x = scaledScreenWidth - width - x;
            off = (float)width - (float)width * settings.scale();
            graphics.method_51448().translate(off, 0.0f);
        }
        if (settings.anchorY() == HudAnchorY.BOTTOM) {
            y = scaledScreenHeight - height - y;
            off = (float)height - (float)height * settings.scale();
            graphics.method_51448().translate(0.0f, off);
        }
        graphics.method_51448().translate((float)x, (float)y);
        graphics.method_51448().scale(settings.scale());
        renderer.render(graphics, (class_1657)HudRenderer.minecraft.field_1724, HudRenderer.minecraft.field_1772, hudData, 2, 2, width - 2, height - 2);
        if (drawEdges) {
            HudRenderer.drawEdges(graphics, 0, 0, width, height, partialTicks);
        }
        graphics.method_51448().popMatrix();
    }

    private static boolean shouldShow() {
        return TCConfig.ENABLE_HUD.get() != false && HudRenderer.minecraft.field_1687 != null && !HudRenderer.minecraft.field_1690.field_1842;
    }

    protected static void drawEdges(class_332 graphics, int xPos, int yPos, int width, int height, float partialTicks) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        float pulse = 0.8f + 0.2f * class_3532.method_15374((float)((partialTicks + (float)player.field_6012) * 0.1f));
        int padding = 7;
        int opacity = class_9848.method_61317((float)pulse);
        graphics.method_25291(class_10799.field_56883, EDGES_TEXTURE, xPos, yPos, 0.0f, 0.0f, 7, 7, 14, 14, opacity);
        graphics.method_25291(class_10799.field_56883, EDGES_TEXTURE, xPos + width - 7, yPos, 7.0f, 0.0f, 7, 7, 14, 14, opacity);
        graphics.method_25291(class_10799.field_56883, EDGES_TEXTURE, xPos, yPos + height - 7, 0.0f, 7.0f, 7, 7, 14, 14, opacity);
        graphics.method_25291(class_10799.field_56883, EDGES_TEXTURE, xPos + width - 7, yPos + height - 7, 7.0f, 7.0f, 7, 7, 14, 14, opacity);
    }
}

