/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.hud.type;

import com.nine.travelerscompass.client.hud.Alignment;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.client.hud.type.IHudTypeRenderer;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ExtendedHudTypeRenderer
implements IHudTypeRenderer {
    public static final int MAX_LINES = 8;

    @Override
    public void render(class_332 graphics, class_1657 player, class_327 font, HudData hudData, int x, int y, int width, int height) {
        if (hudData.isDirty()) {
            hudData.updateCachedData(font, 0);
            hudData.clearDirty();
        }
        HudSettings settings = hudData.getSettings();
        int xPos = x;
        int yPos = y;
        ILocationObject locationObject = hudData.getLocationObject();
        boolean valid = locationObject != null;
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        class_5250 stateTitle = class_2561.method_43471((String)"hud.travelerscompass.extended.state").method_27692(class_124.field_1068);
        class_2561 state = hudData.getState();
        components.add((class_2561)stateTitle);
        components.add(state);
        if (valid) {
            class_5250 targetTitle = class_2561.method_43471((String)"hud.travelerscompass.extended.target").method_27692(class_124.field_1068);
            class_2561 target = hudData.getTargetName();
            class_2338 blockPos = locationObject.blockPos();
            components.add((class_2561)targetTitle);
            components.add(target);
            if (blockPos != null) {
                class_2561 distance = ClientUtils.getDistance(player.method_24515(), blockPos);
                class_2561 position = ExtendedHudTypeRenderer.formatCoordsExtended(blockPos, font, width);
                class_5250 distanceTitle = class_2561.method_43471((String)"hud.travelerscompass.extended.distance").method_27692(class_124.field_1068);
                class_5250 positionTitle = class_2561.method_43471((String)"hud.travelerscompass.extended.position").method_27692(class_124.field_1068);
                components.add((class_2561)positionTitle);
                components.add(position);
                components.add((class_2561)distanceTitle);
                components.add(distance);
            }
        }
        ExtendedHudTypeRenderer.drawExtendedLines(graphics, font, xPos, yPos, width, height, settings.alignment(), 8, components);
    }

    public static void drawExtendedLines(class_332 graphics, class_327 font, int xPos, int yPos, int width, int height, Alignment alignment, int maxLines, List<class_2561> components) {
        if (components.isEmpty()) {
            return;
        }
        maxLines = 4;
        Objects.requireNonNull(font);
        int baseGap = (int)(9.0 * 0.2);
        int extraGaps = (maxLines - 1) / 2;
        Objects.requireNonNull(font);
        int extraGap = (int)(9.0 * 0.4);
        int extraGapsHeight = extraGap * extraGaps;
        Objects.requireNonNull(font);
        int linesHeight = maxLines * (9 * 2 + baseGap) + extraGapsHeight;
        int gap = components.size() > 1 ? (height - linesHeight) / (maxLines - 1) : 0;
        int currentY = yPos;
        int count = 0;
        for (class_2561 component : components) {
            ++count;
            int currentX = xPos;
            switch (alignment) {
                case LEFT: {
                    break;
                }
                case RIGHT: {
                    currentX += width - font.method_27525((class_5348)component);
                    break;
                }
                case CENTER: {
                    currentX += (width - font.method_27525((class_5348)component)) / 2;
                }
            }
            graphics.method_27535(font, component, currentX, currentY, -5592406);
            Objects.requireNonNull(font);
            currentY += 9 + baseGap;
            if (count % 2 != 0) continue;
            currentY += gap;
        }
    }

    public static class_2561 formatCoordsExtended(class_2338 pos, class_327 font, int maxWidth) {
        class_5250 coords = class_2561.method_43470((String)(pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260())).method_27692(class_124.field_1080);
        if (font.method_27525((class_5348)coords) <= maxWidth) {
            return coords;
        }
        coords = class_2561.method_43470((String)(pos.method_10263() + ", " + pos.method_10260())).method_27692(class_124.field_1080);
        if (font.method_27525((class_5348)coords) <= maxWidth) {
            return coords;
        }
        coords = class_2561.method_43470((String)(ClientUtils.compressNumber(pos.method_10263()) + ", " + ClientUtils.compressNumber(pos.method_10260()))).method_27692(class_124.field_1080);
        if (font.method_27525((class_5348)coords) <= maxWidth) {
            return coords;
        }
        return class_2561.method_43470((String)"...").method_27692(class_124.field_1080);
    }
}

