/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.screen;

import com.nine.travelerscompass.client.ClientCache;
import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.InfoButton;
import com.nine.travelerscompass.client.component.button.PauseButton;
import com.nine.travelerscompass.client.component.button.ResetButton;
import com.nine.travelerscompass.client.component.button.SettingsButton;
import com.nine.travelerscompass.client.component.button.TabButton;
import com.nine.travelerscompass.client.component.button.WarningButton;
import com.nine.travelerscompass.client.component.button.WideSearchButton;
import com.nine.travelerscompass.client.component.button.base.BaseButton;
import com.nine.travelerscompass.client.component.button.hud.HudButton;
import com.nine.travelerscompass.client.component.button.popup.PopupButton;
import com.nine.travelerscompass.client.component.button.range.IntRangeButton;
import com.nine.travelerscompass.client.component.button.search.ContainersButton;
import com.nine.travelerscompass.client.component.button.search.FluidSearchModeButton;
import com.nine.travelerscompass.client.component.button.search.InventoriesButton;
import com.nine.travelerscompass.client.component.button.search.SearchModeButton;
import com.nine.travelerscompass.client.component.button.search.VillagersButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import com.nine.travelerscompass.client.component.button.settings.ButtonRangeSettings;
import com.nine.travelerscompass.client.component.button.settings.ButtonSearchModeSettings;
import com.nine.travelerscompass.client.utils.ButtonGrid;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.container.menu.CompassMenu;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.utils.PriorityMode;
import com.nine.travelerscompass.common.utils.TabPage;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.config.cost.SearchCost;
import com.nine.travelerscompass.config.cost.SearchCostHelper;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_9334;

public class CompassScreen
extends class_465<CompassMenu> {
    private static final class_2960 SEARCH_SCREEN_LOCATION = class_2960.method_60655((String)"travelerscompass", (String)"textures/gui/container/compass_screen_1.png");
    private static final class_2960 SETTINGS_SCREEN_LOCATION = class_2960.method_60655((String)"travelerscompass", (String)"textures/gui/container/compass_screen_2.png");
    public static final class_2960 PRIORITY_SLOT = class_2960.method_60655((String)"travelerscompass", (String)"textures/gui/priority_slot.png");
    public class_1799 ghostStack = class_1799.field_8037;
    private final List<ButtonEntry> buttonEntries = new ArrayList<ButtonEntry>();
    private class_1657 player;
    private class_1799 stack;
    private TabPage tabPage;
    private UUID uuid;
    private ButtonGrid grid;
    private TabButton searchTabButton;
    private TabButton settingsTabButton;
    private WarningButton warningButton;
    private SearchModeButton blocksSearchButton;
    private SearchModeButton mobsSearchButton;
    private ContainersButton containersSearchButton;
    private FluidSearchModeButton fluidsSearchButton;
    private SearchModeButton spawnersSearchButton;
    private SearchModeButton dropSearchButton;
    private SearchModeButton itemEntitiesSearchButton;
    private InventoriesButton inventoriesSearchButton;
    private VillagersButton villagersSearchButton;
    private PauseButton pauseButton;
    private WideSearchButton wideSearchButton;
    private InfoButton infoButton;
    private HudButton hudButton;
    private SettingsButton forceChunksLoadButton;
    private SettingsButton targetValidationButton;
    private SettingsButton soundPingButton;
    private SettingsButton heightMarkerButton;
    private SettingsButton priorityButton;
    private IntRangeButton chunksSearchRangeButton;
    private IntRangeButton entitiesSearchRangeButton;
    private IntRangeButton wideSearchRangeButton;

    public CompassScreen(CompassMenu pMenu, class_1661 pPlayerInventory, class_2561 pTitle) {
        super((class_1703)pMenu, pPlayerInventory, pTitle);
        this.field_2792 = 177;
        this.field_2779 = 169;
        this.tabPage = TabPage.SEARCH;
    }

    protected void method_25426() {
        class_1799 stack;
        super.method_25426();
        this.player = class_310.method_1551().field_1724;
        if (this.player == null) {
            return;
        }
        this.stack = stack = this.player.method_6047();
        this.grid = new ButtonGrid(this.field_2776 + 7, this.field_2800 + 7, 14, 14, 2, 2);
        this.uuid = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
        this.tabPage = CompassProperties.get(stack, CompassProperties.TAB_PAGE);
        this.initButtons();
        this.revealButtons(ButtonCategory.STATIC);
        this.revealButtons(this.tabPage == TabPage.SETTINGS ? ButtonCategory.SETTINGS : ButtonCategory.SEARCH);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (ButtonEntry entry : this.buttonEntries) {
            PopupButton popupButton;
            BaseButton button = entry.button;
            if (!entry.active) continue;
            if (button.method_25405(mouseX, mouseY)) {
                button.method_25401(mouseX, mouseY, scrollX, scrollY);
            }
            if (!(button instanceof PopupButton) || !(popupButton = (PopupButton)button).isPopupVisible()) continue;
            popupButton.popupButtons.forEach(b -> {
                if (b.method_25405(mouseX, mouseY)) {
                    b.method_25401(mouseX, mouseY, scrollX, scrollY);
                }
            });
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (ButtonEntry entry : this.buttonEntries) {
            BaseButton baseButton = entry.button;
            if (!(baseButton instanceof PopupButton)) continue;
            PopupButton popupButton = (PopupButton)baseButton;
            if (!entry.active) continue;
            popupButton.popupMouseClicked(mouseX, mouseY, button);
            popupButton.afterPopupClick();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected void method_37432() {
        for (ButtonEntry entry : this.buttonEntries) {
            if (!entry.active) continue;
            entry.button.tick();
        }
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
    }

    private void initSearchModeButtons() {
        ButtonSearchModeSettings.Builder settings = ((ButtonSearchModeSettings.Builder)((ButtonSearchModeSettings.Builder)((ButtonSearchModeSettings.Builder)((ButtonSearchModeSettings.Builder)ButtonSearchModeSettings.builder().size(14, 14)).stackSup(() -> this.stack)).uuid(this.uuid)).mainLayerSet(CompassUI.ButtonTextures.TOGGLE_BUTTON)).lockIcon(CompassUI.CommonTextures.LOCK_ICON);
        this.blocksSearchButton = this.addButton(new SearchModeButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(0), this.grid.y(0))).data(CompassProperties.BLOCKS).configEnabled(TCConfig.ENABLE_BLOCKS_SEARCH.get()).icons(CompassUI.SearchModeTextures.BLOCKS_ACTIVE_ICON, CompassUI.SearchModeTextures.BLOCKS_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.blocksSearchButton = this.addButton(new SearchModeButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(1), this.grid.y(0))).descriptions(new class_2561[]{class_2561.method_43471((String)"tooltip.travelerscompass.search_mode.mobs.desc").method_27692(class_124.field_1080), class_2561.method_43469((String)"tooltip.travelerscompass.search_mode.mobs_shift_click.desc", (Object[])new Object[]{class_2561.method_43471((String)"tooltip.travelerscompass.settings.modification.shift_click")}).method_27692(class_124.field_1080)}).data(CompassProperties.MOBS).configEnabled(TCConfig.ENABLE_MOBS_SEARCH.get()).icons(CompassUI.SearchModeTextures.MOBS_ACTIVE_ICON, CompassUI.SearchModeTextures.MOBS_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.fluidsSearchButton = this.addButton(new FluidSearchModeButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(2), this.grid.y(1))).data(CompassProperties.FLUIDS).configEnabled(TCConfig.ENABLE_FLUIDS_SEARCH.get()).icons(CompassUI.SearchModeTextures.FLUIDS_ACTIVE_ICON, CompassUI.SearchModeTextures.FLUIDS_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.spawnersSearchButton = this.addButton(new SearchModeButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(1), this.grid.y(1))).data(CompassProperties.SPAWNERS).configEnabled(TCConfig.ENABLE_SPAWNERS_SEARCH.get()).icons(CompassUI.SearchModeTextures.SPAWNERS_ACTIVE_ICON, CompassUI.SearchModeTextures.SPAWNERS_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.dropSearchButton = this.addButton(new SearchModeButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(2), this.grid.y(2))).data(CompassProperties.DROP).configEnabled(TCConfig.ENABLE_DROPS_SEARCH.get()).icons(CompassUI.SearchModeTextures.DROP_ACTIVE_ICON, CompassUI.SearchModeTextures.DROP_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.itemEntitiesSearchButton = this.addButton(new SearchModeButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(1), this.grid.y(2))).data(CompassProperties.ITEM_ENTITIES).configEnabled(TCConfig.ENABLE_ITEM_ENTITIES_SEARCH.get()).icons(CompassUI.SearchModeTextures.ITEM_ENTITIES_ACTIVE_ICON, CompassUI.SearchModeTextures.ITEM_ENTITIES_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.containersSearchButton = this.addButton(new ContainersButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(2), this.grid.y(0))).data(CompassProperties.CONTAINERS).configEnabled(TCConfig.ENABLE_BLOCK_CONTAINERS_SEARCH.get()).icons(CompassUI.SearchModeTextures.CONTAINERS_ACTIVE_ICON, CompassUI.SearchModeTextures.CONTAINERS_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.villagersSearchButton = this.addButton(new VillagersButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(0), this.grid.y(1))).data(CompassProperties.VILLAGERS).configEnabled(TCConfig.ENABLE_VILLAGERS_SEARCH.get()).icons(CompassUI.SearchModeTextures.VILLAGERS_ACTIVE_ICON, CompassUI.SearchModeTextures.VILLAGERS_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.inventoriesSearchButton = this.addButton(new InventoriesButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(0), this.grid.y(2))).data(CompassProperties.INVENTORIES).configEnabled(TCConfig.ENABLE_INVENTORIES_SEARCH.get()).icons(CompassUI.SearchModeTextures.INVENTORIES_ACTIVE_ICON, CompassUI.SearchModeTextures.INVENTORIES_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
    }

    private void initUtilButtons() {
        Object settings = ((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)ButtonGenericSettings.builder().uuid(this.uuid)).size(14, 14)).mainLayerSet(CompassUI.ButtonTextures.TOGGLE_BUTTON)).stackSup(() -> this.stack);
        this.infoButton = this.addButton(new InfoButton(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(2), this.grid.y(3))).build()), ButtonCategory.SEARCH);
        this.wideSearchButton = this.addButton(new WideSearchButton(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(1), this.grid.y(3))).build()), ButtonCategory.SEARCH);
        this.pauseButton = this.addButton(new PauseButton(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(0), this.grid.y(3))).build()), ButtonCategory.SEARCH);
    }

    private void initSettingsButtons() {
        Object settings = ((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)ButtonGenericSettings.builder().uuid(this.uuid)).size(14, 14)).mainLayerSet(CompassUI.ButtonTextures.TOGGLE_BUTTON)).stackSup(() -> this.stack);
        this.heightMarkerButton = this.addButton(SettingsButton.create(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(2), this.grid.y(2))).build(), CompassProperties.HEIGHT_MARKER, (cached, hovered) -> {
            if (cached.booleanValue()) {
                return hovered != false ? CompassUI.SettingsTextures.HEIGHT_MARKER_ACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.HEIGHT_MARKER_ACTIVE_ICON;
            }
            return hovered != false ? CompassUI.SettingsTextures.HEIGHT_MARKER_INACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.HEIGHT_MARKER_INACTIVE_ICON;
        }), ButtonCategory.SETTINGS);
        this.targetValidationButton = this.addButton(SettingsButton.create(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(1), this.grid.y(3))).build(), CompassProperties.TARGET_VALIDATION, (cached, hovered) -> {
            if (cached.booleanValue()) {
                return hovered != false ? CompassUI.SettingsTextures.TARGET_VALIDATION_ACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.TARGET_VALIDATION_ACTIVE_ICON;
            }
            return hovered != false ? CompassUI.SettingsTextures.TARGET_VALIDATION_INACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.TARGET_VALIDATION_INACTIVE_ICON;
        }), ButtonCategory.SETTINGS);
        this.soundPingButton = this.addButton(SettingsButton.create(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(0), this.grid.y(2))).build(), CompassProperties.SOUND_PING, (cached, hovered) -> {
            if (cached.booleanValue()) {
                return hovered != false ? CompassUI.SettingsTextures.SOUND_PING_ACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.SOUND_PING_ACTIVE_ICON;
            }
            return hovered != false ? CompassUI.SettingsTextures.SOUND_PING_INACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.SOUND_PING_INACTIVE_ICON;
        }), ButtonCategory.SETTINGS);
        this.forceChunksLoadButton = this.addButton(SettingsButton.create(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(2), this.grid.y(1))).build(), CompassProperties.FORCE_CHUNKS_LOAD, (cached, hovered) -> {
            if (cached.booleanValue()) {
                return hovered != false ? CompassUI.SettingsTextures.FORCE_LOAD_ACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.FORCE_LOAD_ACTIVE_ICON;
            }
            return hovered != false ? CompassUI.SettingsTextures.FORCE_LOAD_INACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.FORCE_LOAD_INACTIVE_ICON;
        }), ButtonCategory.SETTINGS);
        this.priorityButton = this.addButton(new SettingsButton<PriorityMode>(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(1), this.grid.y(2))).build(), CompassProperties.PRIORITY_MODE, (cached, hovered) -> switch (cached) {
            default -> throw new MatchException(null, null);
            case PriorityMode.OFF -> {
                if (hovered.booleanValue()) {
                    yield CompassUI.SettingsTextures.PRIORITY_OFF_HOVERED_ICON;
                }
                yield CompassUI.SettingsTextures.PRIORITY_OFF_ICON;
            }
            case PriorityMode.NORMAL -> {
                if (hovered.booleanValue()) {
                    yield CompassUI.SettingsTextures.PRIORITY_NORMAL_HOVERED_ICON;
                }
                yield CompassUI.SettingsTextures.PRIORITY_NORMAL_ICON;
            }
            case PriorityMode.INVERTED -> hovered != false ? CompassUI.SettingsTextures.PRIORITY_INVERT_HOVERED_ICON : CompassUI.SettingsTextures.PRIORITY_INVERT_ICON;
        }, cached -> "tooltip.travelerscompass.settings.priority_mode." + cached.name().toLowerCase(), cached -> switch (cached) {
            default -> throw new MatchException(null, null);
            case PriorityMode.OFF -> CompassUI.DISABLED;
            case PriorityMode.NORMAL -> CompassUI.ENABLED;
            case PriorityMode.INVERTED -> CompassUI.INVERTED;
        }), ButtonCategory.SETTINGS);
        ResetButton resetButton = this.addButton(new ResetButton(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(2), this.grid.y(3))).afterLeftClick(button -> {
            HudButton.resetHudSettings(this.stack);
            CompassScreen.resetSettings(this.stack);
            this.updateButtons(ButtonCategory.SETTINGS);
            ClientCache.updateAllHudSettings(this.stack, true);
        })).build()), ButtonCategory.SETTINGS);
        this.hudButton = this.addButton(new HudButton(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(0), this.grid.y(3))).build()), ButtonCategory.SETTINGS);
        ButtonRangeSettings.Builder rangeSettings = ButtonRangeSettings.builder(settings).minusIcons(CompassUI.CommonTextures.MINUS_ICON, CompassUI.CommonTextures.MINUS_HOVERED_ICON, CompassUI.CommonTextures.MINUS_INACTIVE_ICON).plusIcons(CompassUI.CommonTextures.PLUS_ICON, CompassUI.CommonTextures.PLUS_HOVERED_ICON, CompassUI.CommonTextures.PLUS_INACTIVE_ICON);
        this.chunksSearchRangeButton = this.addButton(new IntRangeButton(((ButtonRangeSettings.Builder)rangeSettings.copy().position(this.grid.x(1), this.grid.y(0))).icon(CompassUI.SettingsTextures.CHUNKS_RANGE_ICON).build(), 1, TCConfig.BLOCKS_CHUNK_SEARCH_RANGE.get(), 1, 5, CompassProperties.BLOCK_SEARCH_CHUNK_RANGE), ButtonCategory.SETTINGS);
        this.entitiesSearchRangeButton = this.addButton(new IntRangeButton(((ButtonRangeSettings.Builder)rangeSettings.copy().position(this.grid.x(2), this.grid.y(0))).icon(CompassUI.SettingsTextures.ENTITIES_RANGE_ICON).build(), 1, TCConfig.ENTITIES_SEARCH_RANGE.get(), 1, 5, CompassProperties.ENTITIES_SEARCH_RANGE), ButtonCategory.SETTINGS);
        this.entitiesSearchRangeButton = this.addButton(new IntRangeButton(((ButtonRangeSettings.Builder)rangeSettings.copy().position(this.grid.x(1), this.grid.y(1))).icon(CompassUI.SettingsTextures.WIDE_SEARCH_RANGE_ICON).build(), 1, TCConfig.WIDE_SEARCH_RANGE.get(), 1, 5, CompassProperties.WIDE_SEARCH_RANGE), ButtonCategory.SETTINGS);
    }

    private void initTabButtons() {
        Object settings = ((ButtonGenericSettings.Builder)ButtonGenericSettings.builder().size(26, 24)).stackSup(() -> this.stack);
        this.searchTabButton = this.addButton(new TabButton(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).position(this.field_2776 + 130, this.field_2800 + 8)).afterLeftClick(b -> {
            if (this.tabPage == TabPage.SETTINGS) {
                this.searchTabButton.selected = true;
                this.settingsTabButton.selected = false;
                CompassProperties.TAB_PAGE.syncToServer(this.stack, TabPage.SEARCH);
                this.tabPage = TabPage.SEARCH;
                this.revealButtons(ButtonCategory.SEARCH);
                this.hideButtons(ButtonCategory.SETTINGS);
            }
        })).build(), this.tabPage == TabPage.SEARCH, Icon.of(CompassUI.CommonTextures.SEARCH, 6.0f, 4.0f), (class_2561)class_2561.method_43471((String)"tooltip.travelerscompass.search")), ButtonCategory.STATIC);
        this.settingsTabButton = this.addButton(new TabButton(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).position(this.field_2776 + 130, this.field_2800 + 42)).afterLeftClick(b -> {
            if (this.tabPage == TabPage.SEARCH) {
                this.searchTabButton.selected = false;
                this.settingsTabButton.selected = true;
                CompassProperties.TAB_PAGE.syncToServer(this.stack, TabPage.SETTINGS);
                this.tabPage = TabPage.SETTINGS;
                this.revealButtons(ButtonCategory.SETTINGS);
                this.hideButtons(ButtonCategory.SEARCH);
            }
        })).build(), this.tabPage == TabPage.SETTINGS, Icon.of(CompassUI.CommonTextures.SETTINGS, 6.0f, 4.0f), (class_2561)class_2561.method_43471((String)"tooltip.travelerscompass.settings")), ButtonCategory.STATIC);
    }

    private void initButtons() {
        this.buttonEntries.clear();
        this.initTabButtons();
        this.initSearchModeButtons();
        this.initUtilButtons();
        this.initSettingsButtons();
    }

    public static void resetSettings(class_1799 stack) {
        CompassProperties.putDefaultToServer(stack, CompassProperties.WIDE_SEARCH_RANGE);
        CompassProperties.putDefaultToServer(stack, CompassProperties.ENTITIES_SEARCH_RANGE);
        CompassProperties.putDefaultToServer(stack, CompassProperties.BLOCK_SEARCH_CHUNK_RANGE);
        CompassProperties.putDefaultToServer(stack, CompassProperties.FORCE_CHUNKS_LOAD);
        CompassProperties.putDefaultToServer(stack, CompassProperties.SOUND_PING);
        CompassProperties.putDefaultToServer(stack, CompassProperties.PRIORITY_MODE);
        CompassProperties.putDefaultToServer(stack, CompassProperties.HEIGHT_MARKER);
        CompassProperties.putDefaultToServer(stack, CompassProperties.HUD_RENDER_MODE);
        CompassProperties.putDefaultToServer(stack, CompassProperties.TARGET_VALIDATION);
    }

    private void updateButtons(ButtonCategory category) {
        for (ButtonEntry entry : this.buttonEntries) {
            if (!category.equals((Object)entry.category)) continue;
            BaseButton button = entry.button;
            button.updateState();
            if (!(button instanceof PopupButton)) continue;
            PopupButton popupButton = (PopupButton)button;
            popupButton.updatePopupButtons();
        }
    }

    private void revealButtons(ButtonCategory category) {
        for (ButtonEntry entry : this.buttonEntries) {
            if (!category.equals((Object)entry.category)) continue;
            entry.setActive(true);
            this.method_37063((class_364)entry.button);
        }
    }

    private void hideButtons(ButtonCategory category) {
        for (ButtonEntry entry : this.buttonEntries) {
            if (!category.equals((Object)entry.category)) continue;
            entry.setActive(false);
            this.method_37066((class_364)entry.button);
        }
    }

    private <T extends BaseButton> T addButton(T button, ButtonCategory category) {
        this.buttonEntries.add(new ButtonEntry(button, category));
        return button;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.method_2380(guiGraphics, mouseX, mouseY);
        if (this.field_22787 != null && this.field_22787.field_1724 != null && this.field_22787.field_1724.method_6047().method_7909() instanceof TravelersCompassItem) {
            this.stack = this.field_22787.field_1724.method_6047();
        }
    }

    protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        if (!TCConfig.SEARCH_REQUIRES_XP.get().booleanValue()) {
            return;
        }
        class_1735 slot = this.field_2787;
        if (slot != null && slot.field_7871 instanceof CompassContainer) {
            class_1799 carriedStack = ((CompassMenu)this.method_17577()).method_34255();
            if (carriedStack.method_7960() && !this.ghostStack.method_7960()) {
                carriedStack = this.ghostStack;
            }
            if (carriedStack.method_7960()) {
                return;
            }
            class_1792 carried = carriedStack.method_7909();
            SearchCost sc = SearchCostHelper.getCost(carried);
            FilterReason filterReason = FilterManager.getFilterReason(carried);
            if (filterReason.isAllowed()) {
                if (!sc.isFree() && !this.player.method_68878()) {
                    ArrayList<class_5250> extra = new ArrayList<class_5250>();
                    class_5250 req = sc.reqAsComponent().method_27692(sc.meetsRequirement(this.player.field_7520) ? class_124.field_1080 : class_124.field_1061);
                    class_5250 cost = sc.costAsComponent().method_27692(class_124.field_1080);
                    extra.add(req);
                    extra.add(cost);
                    guiGraphics.method_64037(this.field_22793, extra, mouseX, mouseY, (class_2960)carriedStack.method_58694(class_9334.field_54198));
                }
            } else {
                guiGraphics.method_64235(this.field_22793, ClientCache.formatFilterReason(filterReason), mouseX, mouseY, (class_2960)carriedStack.method_58694(class_9334.field_54198));
            }
        }
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && this.stack != null) {
            int w = (this.field_22789 - this.field_2792) / 2;
            int h = (this.field_22790 - this.field_2779) / 2;
            graphics.method_25290(class_10799.field_56883, this.tabPage.equals((Object)TabPage.SEARCH) ? SEARCH_SCREEN_LOCATION : SETTINGS_SCREEN_LOCATION, w, h, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
            for (int i : CompassProperties.get(this.stack, CompassProperties.PRIORITY_SLOTS)) {
                int j = i > 2 ? 1 : 0;
                j = i > 5 ? 2 : j;
                int c = i > 2 ? i - 3 : i;
                c = i > 5 ? i - 6 : c;
                graphics.method_25290(class_10799.field_56883, PRIORITY_SLOT, this.field_2776 + 72 + c * 18, this.field_2800 + 10 + j * 18, 0.0f, 0.0f, 18, 18, 18, 18);
            }
        }
    }

    public int leftPos() {
        return this.field_2776;
    }

    public int topPos() {
        return this.field_2800;
    }

    private static enum ButtonCategory {
        SEARCH,
        SETTINGS,
        STATIC;

    }

    private static class ButtonEntry {
        public final BaseButton button;
        public final ButtonCategory category;
        public boolean active;

        private ButtonEntry(BaseButton button, ButtonCategory category) {
            this.button = button;
            this.category = category;
            this.active = false;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }
}

