/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.container;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.config.cost.SearchCostHelper;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1739;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9288;

public class CompassContainer
implements class_1263 {
    private final class_1799 containerStack;
    private final class_2371<class_1799> inventory;
    private final int maxStackSize;

    private CompassContainer(class_1799 containerStack, int inventorySize, int maxStackSize) {
        this.containerStack = containerStack;
        this.maxStackSize = maxStackSize;
        this.inventory = class_2371.method_10213((int)inventorySize, (Object)class_1799.field_8037);
        this.load();
    }

    public static CompassContainer container(class_1799 containerHolder) {
        return new CompassContainer(containerHolder, 9, 1);
    }

    public List<class_1792> getList() {
        ArrayList<class_1792> list = new ArrayList<class_1792>();
        for (int i = 0; i < 9; ++i) {
            class_1792 item = this.method_5438(i).method_7909();
            if (item instanceof class_1739) continue;
            list.add(item);
        }
        return list;
    }

    public boolean hasAny(class_1799 itemStack) {
        for (int i = 0; i < 9; ++i) {
            if (!itemStack.method_31574(this.method_5438(i).method_7909())) continue;
            return true;
        }
        return false;
    }

    public int getFirstEmptySlot() {
        for (int i = 0; i < 9; ++i) {
            if (!this.method_5438(i).method_31574(class_1799.field_8037.method_7909())) continue;
            return i;
        }
        return 0;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public class_1799 method_5438(int index) {
        return (class_1799)this.inventory.get(index);
    }

    public void load() {
        class_9288 container = CompassProperties.CONTAINER.get(this.containerStack);
        if (container != null) {
            container.method_57492(this.inventory);
        }
    }

    public void save() {
        CompassProperties.CONTAINER.set(this.containerStack, class_9288.method_57493(this.inventory));
    }

    public class_1799 method_5434(int index, int size) {
        class_1799 stack = this.method_5438(index);
        if (!stack.method_7960()) {
            if (stack.method_7947() > size) {
                stack = stack.method_7971(size);
                this.method_5431();
            } else {
                this.method_5447(index, class_1799.field_8037);
            }
        }
        stack.method_7939(0);
        return stack;
    }

    public class_1799 method_5441(int index) {
        class_1799 stack = this.method_5438(index);
        this.method_5447(index, class_1799.field_8037);
        return stack;
    }

    public void method_5447(int index, class_1799 stack) {
        this.setItem(index, stack, null);
    }

    public void setItem(int index, class_1799 stack, class_1657 player) {
        FilterReason filterReason;
        if (stack.method_7909() instanceof TravelersCompassItem) {
            return;
        }
        if (stack == class_1799.field_8037) {
            this.inventory.set(index, (Object)stack);
            if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
                stack.method_7939(this.method_5444());
            }
            this.method_5431();
        }
        if ((filterReason = FilterManager.getFilterReason(stack.method_7909())).isAllowed() && (player == null || SearchCostHelper.consumeXp(player, stack.method_7909()))) {
            this.inventory.set(index, (Object)stack);
            if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
                stack.method_7939(this.method_5444());
            }
            this.method_5431();
        }
    }

    public int method_5444() {
        return this.maxStackSize;
    }

    public void method_5431() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (this.method_5438(i).method_7960() || this.method_5438(i).method_7947() != 0) continue;
            this.inventory.set(i, (Object)class_1799.field_8037);
        }
        this.save();
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5435(class_1657 player) {
    }

    public void method_5432(class_1657 player) {
    }

    public boolean method_5437(int index, class_1799 stack) {
        return true;
    }

    public void method_5448() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)class_1799.field_8037);
        }
    }

    public boolean method_5442() {
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }
}

