/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search;

import com.nine.travelerscompass.client.utils.SearchProgress;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.SearchOptions;
import com.nine.travelerscompass.common.search.SearchProcess;
import com.nine.travelerscompass.common.search.SearchResult;
import com.nine.travelerscompass.common.search.criterion.TypedCriteria;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.matcher.BlockEntityMatcher;
import com.nine.travelerscompass.common.search.matcher.BlockMatcher;
import com.nine.travelerscompass.common.search.matcher.EntityMatcher;
import com.nine.travelerscompass.common.search.matcher.PositionMatchers;
import com.nine.travelerscompass.common.utils.PriorityMode;
import com.nine.travelerscompass.common.utils.SearchState;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.network.packet.s2c.SearchProgressSyncPacket;
import com.nine.travelerscompass.platform.Platform;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SearchManager {
    public static boolean scannedSmth = false;
    private static final int CHUNKS_PER_TICK = TCConfig.MAX_CHUNK_SCANS_PER_TICK_ON_SERVER.get();
    private static final int CHUNKS_PER_COMPASS = TCConfig.MAX_CHUNK_SCANS_PER_COMPASS.get();
    private static final int GENERATIONS_PER_TICK = TCConfig.MAX_FORCE_CHUNK_GENERATION_PER_TICK.get();
    public static final ExecutorService SCAN_EXECUTOR = Executors.newFixedThreadPool(2, r -> {
        Thread t = new Thread(r, "Compass-scan-executor");
        t.setDaemon(true);
        return t;
    });
    private static final Map<UUID, SearchProcess> ACTIVE_SCAN_PROCESSES = new HashMap<UUID, SearchProcess>();
    private static final Queue<UUID> PROCESS_QUEUE = new ArrayDeque<UUID>();
    public static final Map<UUID, CachedLocations> FOUND_DATA_CACHE = new ConcurrentHashMap<UUID, CachedLocations>();
    public static final Map<UUID, UUID> PROGRESS_WATCHERS = new HashMap<UUID, UUID>();

    public static void addWatcher(UUID compass, UUID player) {
        PROGRESS_WATCHERS.putIfAbsent(compass, player);
    }

    public static void removeWatcher(UUID compass, class_3222 player) {
        PROGRESS_WATCHERS.remove(compass, player.method_5667());
        Platform.PLATFORM_NETWORK.sendToClient(player, new SearchProgressSyncPacket(new SearchProgress(-1, -1), compass));
    }

    public static boolean inQueue(UUID uuid) {
        return ACTIVE_SCAN_PROCESSES.containsKey(uuid);
    }

    private static void notifyWatcher(class_1937 level, SearchProgress progress, UUID uuid) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (PROGRESS_WATCHERS.containsKey(uuid)) {
                UUID playerUuid = PROGRESS_WATCHERS.get(uuid);
                MinecraftServer server = serverLevel.method_8503();
                class_3222 player = server.method_3760().method_14602(playerUuid);
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = player;
                    Platform.PLATFORM_NETWORK.sendToClient(serverPlayer, new SearchProgressSyncPacket(progress, uuid));
                }
            }
        }
    }

    public static void tick() {
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        int totalChunksScanned = 0;
        int totalChunksGenerated = 0;
        int qSize = PROCESS_QUEUE.size();
        scannedSmth = qSize > 0;
        for (int i = 0; i < qSize; ++i) {
            int generationLimit;
            int availableChunks;
            UUID uuid = PROCESS_QUEUE.poll();
            SearchProcess job = ACTIVE_SCAN_PROCESSES.get(uuid);
            if (job == null) continue;
            if (job.shouldSyncProgress()) {
                int progress = job.wideSearch && job.allowChunkGen ? job.chunksLoaded : job.chunksPassed;
                SearchManager.notifyWatcher(job.level, new SearchProgress(progress, job.chunksToScan - 1), uuid);
            }
            if (job.tickAsync(availableChunks = SearchManager.calculateChunksBudget(totalChunksScanned), generationLimit = SearchManager.calculateGenerationBudget(totalChunksGenerated))) {
                if (job.onComplete != null) {
                    job.scanEntities();
                    job.onComplete.accept(job.result);
                    SearchManager.notifyWatcher(job.level, new SearchProgress(0, job.chunksToScan - 1), uuid);
                }
                toRemove.add(uuid);
            } else {
                PROCESS_QUEUE.add(uuid);
            }
            totalChunksScanned += job.chunksPassedLastTick;
            totalChunksGenerated += job.chunksForceLoadedLastTick;
        }
        for (UUID uuid : toRemove) {
            ACTIVE_SCAN_PROCESSES.remove(uuid);
        }
    }

    private static int calculateChunksBudget(int scanned) {
        if (scanned >= CHUNKS_PER_TICK) {
            return 0;
        }
        if (CHUNKS_PER_COMPASS + scanned > CHUNKS_PER_TICK) {
            return CHUNKS_PER_TICK - scanned;
        }
        return CHUNKS_PER_COMPASS;
    }

    private static int calculateGenerationBudget(int generated) {
        if (generated >= GENERATIONS_PER_TICK) {
            return 0;
        }
        return GENERATIONS_PER_TICK - generated;
    }

    public static void startWideSearch(class_1799 stack, class_3222 player, CompassContainer container) {
        UUID uuid = CompassProperties.COMPASS_UUID.get(stack);
        SearchManager.stopScan(uuid);
        CompassProperties.PAUSE.set(stack, true);
        CompassProperties.SEARCH_STATE.set(stack, SearchState.WIDE_SEARCHING);
        SearchManager.startSearch(stack, player, container, true, result -> {
            SearchManager.validatePriority(stack);
            SearchManager.saveClosest(result.get(), player.method_24515(), uuid, TCConfig.MAX_CACHED_LOCATIONS.get(), CompassProperties.PRIORITY_MODE.get(stack));
            CompassProperties.SEARCH_STATE.set(stack, SearchState.IDLE);
            if (CompassProperties.TARGET_VALIDATION.get(stack).booleanValue()) {
                SearchManager.validatePositions((class_1937)player.method_51469(), uuid);
            }
        });
    }

    public static void startSearch(class_1799 stack, class_3222 player, CompassContainer container, boolean wideSearch, Consumer<SearchResult> onComplete) {
        UUID uuid = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
        class_3218 level = player.method_51469();
        if (ACTIVE_SCAN_PROCESSES.containsKey(uuid)) {
            return;
        }
        if (!PROGRESS_WATCHERS.containsKey(uuid)) {
            PROGRESS_WATCHERS.put(uuid, player.method_5667());
        }
        SearchOptions options = new SearchOptions(stack, player, wideSearch);
        TypedCriteria criteria = new TypedCriteria(TypedCriteria.extractCriteria(container, stack, (class_1937)level));
        List<BlockMatcher> blocksMatcher = PositionMatchers.BLOCK_MATCHERS.stream().filter(m -> m.isAllowed(options)).toList();
        List<BlockEntityMatcher> blockEntitiesMatcher = PositionMatchers.BLOCK_ENTITY_MATCHERS.stream().filter(m -> m.isAllowed(options)).toList();
        List<EntityMatcher> entitiesMatcher = PositionMatchers.ENTITY_MATCHERS.stream().filter(m -> m.isAllowed(options)).toList();
        boolean allowChunkGen = CompassProperties.FORCE_CHUNKS_LOAD.get(stack) != false && TCConfig.MAX_FORCE_CHUNK_GENERATION_PER_TICK.get() > 0;
        PROCESS_QUEUE.add(uuid);
        ACTIVE_SCAN_PROCESSES.put(uuid, new SearchProcess((class_1657)player, allowChunkGen, options, criteria, blocksMatcher, blockEntitiesMatcher, entitiesMatcher, onComplete));
    }

    public static void clearFoundBlocks(UUID uuid) {
        FOUND_DATA_CACHE.remove(uuid);
    }

    public static ILocationObject getClosestLocation(class_2338 playerPos, UUID uuid, PriorityMode priorityMode) {
        if (FOUND_DATA_CACHE.containsKey(uuid)) {
            return FOUND_DATA_CACHE.get(uuid).getClosest(playerPos, priorityMode);
        }
        return null;
    }

    public static void stopScan(UUID uuid) {
        if (ACTIVE_SCAN_PROCESSES.containsKey(uuid)) {
            ACTIVE_SCAN_PROCESSES.get(uuid).setCanceled();
        }
        ACTIVE_SCAN_PROCESSES.remove(uuid);
        PROCESS_QUEUE.remove(uuid);
    }

    public static void saveClosest(List<ILocationObject> allData, class_2338 playerPos, UUID uuid, int limit, PriorityMode priorityMode) {
        Comparator<ILocationObject> byDistance = Comparator.comparingDouble(p -> p.blockPos().method_10262((class_2382)playerPos));
        ArrayList<ILocationObject> all = new ArrayList<ILocationObject>(allData);
        if (priorityMode.equals((Object)PriorityMode.OFF)) {
            all.sort(byDistance);
            FOUND_DATA_CACHE.put(uuid, new CachedLocations(all.subList(0, Math.min(all.size(), limit))));
            return;
        }
        ArrayList<ILocationObject> priority = new ArrayList<ILocationObject>();
        ArrayList<ILocationObject> nonPriority = new ArrayList<ILocationObject>();
        for (ILocationObject loc : all) {
            if (loc.priority()) {
                priority.add(loc);
                continue;
            }
            nonPriority.add(loc);
        }
        priority.sort(byDistance);
        nonPriority.sort(byDistance);
        ArrayList<ILocationObject> result = new ArrayList<ILocationObject>();
        if (priorityMode == PriorityMode.NORMAL) {
            result.addAll(priority.subList(0, Math.min(priority.size(), limit)));
            int remaining = limit - result.size();
            result.addAll(nonPriority.subList(0, Math.min(nonPriority.size(), remaining)));
        } else if (priorityMode == PriorityMode.INVERTED) {
            result.addAll(nonPriority.subList(0, Math.min(nonPriority.size(), limit)));
            int remaining = limit - result.size();
            result.addAll(priority.subList(0, Math.min(priority.size(), remaining)));
        }
        FOUND_DATA_CACHE.put(uuid, new CachedLocations(result));
    }

    public static void validatePositions(class_1937 level, UUID uuid) {
        if (!FOUND_DATA_CACHE.containsKey(uuid)) {
            return;
        }
        List<ILocationObject> dataList = SearchManager.FOUND_DATA_CACHE.get((Object)uuid).locations;
        if (dataList == null) {
            return;
        }
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            dataList.removeIf(s -> !s.isValid(serverLevel));
            dataList.replaceAll(s -> s.update(serverLevel).orElse((ILocationObject)s));
        }
    }

    public static void validatePriority(class_1799 stack) {
        UUID uuid = CompassProperties.COMPASS_UUID.get(stack);
        if (!FOUND_DATA_CACHE.containsKey(uuid)) {
            return;
        }
        List<ILocationObject> dataList = SearchManager.FOUND_DATA_CACHE.get((Object)uuid).locations;
        if (dataList == null) {
            return;
        }
        Set set = Set.copyOf((Collection)CompassProperties.PRIORITY_SLOTS.get(stack));
        for (ILocationObject object : dataList) {
            object.withPriority(set.contains(object.slotIndex()));
        }
    }

    public static void updateSlotPriority(UUID uuid, int slotIndex, boolean priority) {
        if (!FOUND_DATA_CACHE.containsKey(uuid)) {
            return;
        }
        List<ILocationObject> locations = SearchManager.FOUND_DATA_CACHE.get((Object)uuid).locations;
        for (int i = 0; i < locations.size(); ++i) {
            ILocationObject data = locations.get(i);
            if (data.slotIndex() != slotIndex) continue;
            locations.set(i, data.withPriority(priority));
        }
    }

    public static class CachedLocations {
        private static final int MIN_RESORT_DIST = 5;
        private static final int FUll_RESORT_TICKS = 100;
        private static final int QUICK_RESORT_TICKS = 20;
        private static final int QUICK_RESORT_AMOUNT = 5;
        public List<ILocationObject> locations;
        private int ticksSinceSort = 0;
        private class_2338 closestPos = class_2338.field_10980;

        CachedLocations(List<ILocationObject> locations) {
            this.locations = locations;
        }

        public ILocationObject getClosest(class_2338 playerPos, PriorityMode priorityMode) {
            ++this.ticksSinceSort;
            boolean fullResort = false;
            boolean quickResort = false;
            int size = this.locations.size();
            if (size > 0) {
                if (playerPos.method_10262((class_2382)this.closestPos) > 25.0) {
                    fullResort = true;
                } else if (this.ticksSinceSort >= 100) {
                    fullResort = true;
                    this.ticksSinceSort = 0;
                } else if (this.ticksSinceSort % 20 == 0) {
                    quickResort = true;
                }
                if (fullResort) {
                    this.sort(playerPos, priorityMode, size);
                } else if (quickResort) {
                    this.sort(playerPos, priorityMode, 5);
                }
            }
            return size == 0 ? null : this.locations.getFirst();
        }

        private void sort(class_2338 playerPos, PriorityMode priorityMode, int limit) {
            int size = Math.min(this.locations.size(), limit);
            this.locations.subList(0, size).sort(this.getComparator(playerPos, priorityMode));
            this.closestPos = this.locations.getFirst().blockPos();
        }

        private Comparator<ILocationObject> getComparator(class_2338 playerPos, PriorityMode priorityMode) {
            return (a, b) -> {
                double distA = a.blockPos().method_10262((class_2382)playerPos);
                double distB = b.blockPos().method_10262((class_2382)playerPos);
                boolean pa = a.priority();
                boolean pb = b.priority();
                switch (priorityMode) {
                    case NORMAL: {
                        if (pa == pb) break;
                        return pa ? -1 : 1;
                    }
                    case OFF: {
                        return Double.compare(distA, distB);
                    }
                    case INVERTED: {
                        if (pa == pb) break;
                        return pa ? 1 : -1;
                    }
                }
                return Double.compare(distA, distB);
            };
        }
    }
}

