/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search;

import com.nine.travelerscompass.common.search.ChunkIterator;
import com.nine.travelerscompass.common.search.SearchManager;
import com.nine.travelerscompass.common.search.SearchOptions;
import com.nine.travelerscompass.common.search.SearchResult;
import com.nine.travelerscompass.common.search.criterion.TypedCriteria;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.matcher.BlockEntityMatcher;
import com.nine.travelerscompass.common.search.matcher.BlockMatcher;
import com.nine.travelerscompass.common.search.matcher.EntityMatcher;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.server.MinecraftServer;

public class SearchProcess {
    private volatile boolean isAsyncRunning;
    private final AtomicBoolean canceled = new AtomicBoolean(false);
    final List<BlockMatcher> blockMatchers;
    final List<BlockEntityMatcher> blockEntityMatchers;
    final List<EntityMatcher> entityMatchers;
    final SearchOptions options;
    final TypedCriteria criteria;
    public final boolean allowChunkGen;
    public final boolean wideSearch;
    public final class_1937 level;
    final class_2338 playerPos;
    final Queue<class_1923> deferredChunks = new ArrayDeque<class_1923>();
    private final ChunkIterator chunkIterator;
    int lastSyncedProgress;
    public final int chunksToScan;
    public int chunksPassed = 0;
    public int chunksPassedLastTick = 0;
    public int chunksLoaded = 0;
    int chunksLoadedLastTick = 0;
    public int chunksForceLoaded = 0;
    public int chunksForceLoadedLastTick = 0;
    final int entitiesSearchRange;
    public final SearchResult result = new SearchResult();
    public final Consumer<SearchResult> onComplete;

    public SearchProcess(class_1657 player, boolean allowChunkGen, SearchOptions options, TypedCriteria criteria, List<BlockMatcher> bMatchers, List<BlockEntityMatcher> beMatchers, List<EntityMatcher> eMatchers, Consumer<SearchResult> onComplete) {
        this.allowChunkGen = allowChunkGen;
        this.wideSearch = options.wideSearch();
        this.level = player.method_37908();
        this.criteria = criteria;
        this.options = options;
        this.entitiesSearchRange = options.getEntitiesSearchRange();
        this.playerPos = player.method_24515();
        this.blockMatchers = bMatchers;
        this.blockEntityMatchers = beMatchers;
        this.entityMatchers = eMatchers;
        this.onComplete = onComplete;
        this.chunksToScan = (int)Math.pow(1 + options.getChunksSearchRange() * 2, 2.0);
        this.chunkIterator = new ChunkIterator(this.playerPos, options.getChunksSearchRange());
    }

    public void scanEntities() {
        class_238 aabb = new class_238(class_243.method_24954((class_2382)this.playerPos.method_10069(-this.entitiesSearchRange, -this.entitiesSearchRange, -this.entitiesSearchRange)), class_243.method_24954((class_2382)this.playerPos.method_10069(this.entitiesSearchRange, this.entitiesSearchRange, this.entitiesSearchRange)));
        List list = this.level.method_18467(class_1297.class, aabb);
        if (this.entityMatchers.isEmpty()) {
            return;
        }
        for (class_1297 entity : list) {
            FilterReason filterReason = FilterManager.getFilterReason(entity.method_5864());
            if (!filterReason.isAllowed()) continue;
            for (EntityMatcher matcher : this.entityMatchers) {
                List<ILocationObject> data = matcher.match(this.criteria, this.options, entity, this.level, entity.method_24515());
                if (data == null) continue;
                this.result.addAll(data);
            }
        }
    }

    public boolean tickAsync(int chunksLimit, int generationLimit) {
        if (this.isAsyncRunning || chunksLimit == 0) {
            return false;
        }
        MinecraftServer server = this.level.method_8503();
        if (server == null || this.canceled.get()) {
            return true;
        }
        this.chunksPassedLastTick = 0;
        this.chunksForceLoadedLastTick = 0;
        this.chunksLoadedLastTick = 0;
        ArrayList<class_2791> chunkList = new ArrayList<class_2791>();
        while (this.chunkIterator.hasNext()) {
            boolean force;
            ++this.chunksPassed;
            ++this.chunksPassedLastTick;
            class_1923 pos = this.chunkIterator.next();
            boolean chunkLoaded = this.level.method_8393(pos.field_9181, pos.field_9180);
            boolean bl = force = this.allowChunkGen && !chunkLoaded && generationLimit > 0 && this.chunksForceLoadedLastTick <= generationLimit;
            if (force || chunkLoaded) {
                class_2791 chunkAccess = this.level.method_8402(pos.field_9181, pos.field_9180, class_2806.field_12803, force);
                ++this.chunksLoaded;
                ++this.chunksLoadedLastTick;
                if (force) {
                    ++this.chunksForceLoaded;
                    ++this.chunksForceLoadedLastTick;
                }
                if (chunkAccess != null) {
                    chunkList.add(chunkAccess);
                }
            } else if (this.allowChunkGen && this.wideSearch) {
                this.deferredChunks.add(pos);
            }
            if (this.chunksPassedLastTick < chunksLimit) continue;
            break;
        }
        if (this.wideSearch && this.allowChunkGen && this.chunksLoadedLastTick < chunksLimit) {
            int lim = chunksLimit - chunkList.size();
            while (lim > 0 && !this.deferredChunks.isEmpty()) {
                boolean force;
                class_1923 pos = this.deferredChunks.peek();
                boolean loaded = this.level.method_8393(pos.field_9181, pos.field_9180);
                boolean bl = force = generationLimit > 0 && this.chunksForceLoadedLastTick < generationLimit;
                if (!loaded && force) break;
                class_2791 currentChunk = this.level.method_8402(pos.field_9181, pos.field_9180, class_2806.field_12803, !loaded);
                if (currentChunk == null) break;
                this.deferredChunks.poll();
                chunkList.add(currentChunk);
                --lim;
                if (!loaded) {
                    ++this.chunksForceLoaded;
                    ++this.chunksForceLoadedLastTick;
                }
                ++this.chunksLoaded;
                ++this.chunksLoadedLastTick;
            }
        }
        ArrayList blockEntityPositions = new ArrayList();
        this.isAsyncRunning = true;
        CompletableFuture.supplyAsync(() -> {
            ArrayList<ILocationObject> localDataList = new ArrayList<ILocationObject>();
            for (class_2791 chunkAccess : chunkList) {
                class_2826[] sections = chunkAccess.method_12006();
                int minSectionY = chunkAccess.method_32891();
                int baseX = chunkAccess.method_12004().field_9181 << 4;
                int baseZ = chunkAccess.method_12004().field_9180 << 4;
                blockEntityPositions.addAll(chunkAccess.method_12021());
                for (int s = 0; s < sections.length; ++s) {
                    class_2841 palette;
                    boolean shouldScanBlocks;
                    class_2826 section = sections[s];
                    if (section == null || section.method_38292() || !(shouldScanBlocks = (palette = section.method_12265()).method_19526(state -> this.criteria.placeableBlocks.contains(state.method_26204())))) continue;
                    int baseY = minSectionY + s << 4;
                    class_2338.class_2339 mutablePos = new class_2338.class_2339();
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            for (int y = 0; y < 16; ++y) {
                                class_2680 state2 = section.method_12254(x, y, z);
                                if (state2.method_26215()) continue;
                                for (BlockMatcher matcher : this.blockMatchers) {
                                    mutablePos.method_10103(baseX + x, baseY + y, baseZ + z);
                                    ILocationObject data = matcher.match(this.criteria, mutablePos.method_10062(), state2);
                                    if (data == null) continue;
                                    localDataList.add(data);
                                }
                            }
                        }
                    }
                }
            }
            return localDataList;
        }).thenAcceptAsync(threadResult -> server.execute(() -> {
            if (this.canceled.get()) {
                this.isAsyncRunning = false;
                return;
            }
            try {
                for (class_2338 pos : blockEntityPositions) {
                    class_2680 state = this.level.method_8320(pos);
                    class_2586 be = this.level.method_8321(pos);
                    if (be == null) continue;
                    for (BlockEntityMatcher matcher : this.blockEntityMatchers) {
                        List<ILocationObject> data = matcher.match(this.criteria, this.options, pos, state, be);
                        if (data == null) continue;
                        this.result.addAll(data);
                    }
                }
                this.result.addAll((List<ILocationObject>)threadResult);
            }
            finally {
                this.isAsyncRunning = false;
            }
        }), (Executor)SearchManager.SCAN_EXECUTOR);
        return this.chunksPassed >= this.chunksToScan && !this.canScanAboveLimit() || this.canceled.get();
    }

    private boolean canScanAboveLimit() {
        return this.wideSearch && this.allowChunkGen && !this.deferredChunks.isEmpty();
    }

    public void setCanceled() {
        this.canceled.set(true);
    }

    public boolean shouldSyncProgress() {
        int current = this.chunksPassed * 100 / this.chunksToScan;
        if (current != this.lastSyncedProgress || this.chunksToScan <= this.chunksPassed) {
            this.lastSyncedProgress = current;
            return true;
        }
        return false;
    }
}

