/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.criterion;

import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.criterion.BlockCriterion;
import com.nine.travelerscompass.common.search.criterion.EntityCriterion;
import com.nine.travelerscompass.common.search.criterion.FluidCriterion;
import com.nine.travelerscompass.common.search.criterion.IPlaceableCriterion;
import com.nine.travelerscompass.common.search.criterion.ISearchCriterion;
import com.nine.travelerscompass.common.search.criterion.ItemCriterion;
import com.nine.travelerscompass.mixin.accessor.BucketItemAccessor;
import com.nine.travelerscompass.platform.accessor.MobBucketItemAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1739;
import net.minecraft.class_1747;
import net.minecraft.class_1755;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_3611;
import net.minecraft.class_7225;

public class TypedCriteria {
    public final Set<EntityCriterion> entityCriteria;
    public final Set<ItemCriterion> itemCriteria;
    public final Set<FluidCriterion> fluidCriteria;
    public final Set<BlockCriterion> blockCriteria;
    public final Map<class_1792, ISearchCriterion> itemCriteriaMap;
    public final Set<class_2248> placeableBlocks;

    public TypedCriteria(List<ISearchCriterion> criteria) {
        this.entityCriteria = TypedCriteria.quickFill(criteria, EntityCriterion.class);
        this.itemCriteria = TypedCriteria.quickFill(criteria, ItemCriterion.class);
        this.fluidCriteria = TypedCriteria.quickFill(criteria, FluidCriterion.class);
        this.blockCriteria = TypedCriteria.quickFill(criteria, BlockCriterion.class);
        this.itemCriteriaMap = TypedCriteria.criteriaToMap(criteria);
        this.placeableBlocks = criteria.stream().filter(c -> c instanceof IPlaceableCriterion).map(c -> ((IPlaceableCriterion)((Object)c)).asBlock()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static <T> Set<T> quickFill(List<ISearchCriterion> list, Class<T> type) {
        return list.stream().filter(type::isInstance).map(type::cast).collect(Collectors.toSet());
    }

    private static Map<class_1792, ISearchCriterion> criteriaToMap(List<? extends ISearchCriterion> list) {
        HashMap<class_1792, ISearchCriterion> searchItemsMap = new HashMap<class_1792, ISearchCriterion>();
        for (ISearchCriterion iSearchCriterion : list) {
            if (!(iSearchCriterion instanceof ItemCriterion)) continue;
            ItemCriterion itemCriterion = (ItemCriterion)iSearchCriterion;
            searchItemsMap.put(itemCriterion.item(), iSearchCriterion);
        }
        return searchItemsMap;
    }

    public static List<ISearchCriterion> extractCriteria(CompassContainer container, class_1799 stack, class_1937 level) {
        List<Integer> array = CompassProperties.get(stack, CompassProperties.PRIORITY_SLOTS);
        ArrayList<ISearchCriterion> ret = new ArrayList<ISearchCriterion>();
        HashSet<Integer> priorSlots = new HashSet<Integer>();
        for (int slot : array) {
            priorSlots.add(slot);
        }
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1755 bucketItem;
            class_3611 fluid;
            class_1799 cStack = container.method_5438(i);
            class_1792 item = cStack.method_7909();
            if (item instanceof class_1739) continue;
            boolean prior = priorSlots.contains(i);
            ret.add(new ItemCriterion(item, prior, i));
            if (item instanceof class_1747) {
                class_1747 blockItem = (class_1747)item;
                ret.add(new BlockCriterion(blockItem.method_7711(), prior, i));
            }
            if (item instanceof class_1755 && (fluid = ((BucketItemAccessor)(bucketItem = (class_1755)item)).travelerscompass$content()) != null) {
                ret.add(new FluidCriterion(fluid, prior, i));
            }
            if (item instanceof class_1826) {
                class_1826 spawnEggItem = (class_1826)item;
                ret.add(new EntityCriterion(spawnEggItem.method_8015((class_7225.class_7874)level.method_30349(), stack), prior, i));
            }
            if (!(item instanceof class_1785)) continue;
            class_1785 mobBucketItem = (class_1785)item;
            class_1299<?> type = ((MobBucketItemAccessor)mobBucketItem).travelerscompass$getType();
            ret.add(new EntityCriterion(type, prior, i));
        }
        return ret;
    }
}

