/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.location;

import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.codec.LocationCodec;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public record BlockLocationObject(class_2338 blockPos, int slotIndex, boolean priority, String descriptionId, class_2960 blockId) implements ILocationObject
{
    public static class_2960 TYPE = class_2960.method_60655((String)"travelerscompass", (String)"block_location_codec");
    public static final LocationCodec<BlockLocationObject> CODEC = new LocationCodec<BlockLocationObject>(){

        @Override
        public void write(class_2540 buf, BlockLocationObject obj) {
            this.writePosSafe(buf, obj.blockPos);
            buf.method_53002(obj.slotIndex);
            buf.method_52964(obj.priority);
            buf.method_10814(obj.descriptionId);
            buf.method_10812(obj.blockId);
        }

        @Override
        public BlockLocationObject read(class_2540 buf) {
            class_2338 blockPos = this.readPosSafe(buf);
            int slotIndex = buf.readInt();
            boolean priority = buf.readBoolean();
            String descriptionId = buf.method_19772();
            class_2960 blockId = buf.method_10810();
            return new BlockLocationObject(blockPos, slotIndex, priority, descriptionId, blockId);
        }
    };

    @Override
    public class_2960 type() {
        return TYPE;
    }

    @Override
    public ILocationObject copy(class_2338 blockPos, int slotIndex, boolean priority, String descriptionId) {
        return new BlockLocationObject(blockPos, slotIndex, priority, descriptionId, this.blockId);
    }

    @Override
    public boolean isValid(class_3218 level) {
        if (!level.method_8477(this.blockPos)) {
            return true;
        }
        class_2248 block = level.method_8320(this.blockPos).method_26204();
        return class_7923.field_41175.method_10223(this.blockId).map(class_6880.class_6883::comp_349).map(refBlock -> refBlock == block).orElse(false);
    }

    @Override
    public Optional<ILocationObject> update(class_3218 level) {
        return Optional.of(this);
    }

    @Override
    public String toString() {
        return "Block Location: [" + this.descriptionId + "], " + String.valueOf(this.blockPos) + (this.priority ? " [priority]" : "");
    }
}

