/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.location;

import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithContent;
import com.nine.travelerscompass.common.search.location.codec.LocationCodec;
import com.nine.travelerscompass.platform.Platform;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public record ContainerLocationObject(class_2338 blockPos, int slotIndex, boolean priority, int containerSlotIndex, String descriptionId, String contentId, class_2960 blockId) implements ILocationObject,
WithContent
{
    public static class_2960 TYPE = class_2960.method_60655((String)"travelerscompass", (String)"container_location_codec");
    public static final LocationCodec<ContainerLocationObject> CODEC = new LocationCodec<ContainerLocationObject>(){

        @Override
        public void write(class_2540 buf, ContainerLocationObject obj) {
            this.writePosSafe(buf, obj.blockPos);
            buf.method_53002(obj.slotIndex);
            buf.method_52964(obj.priority);
            buf.method_53002(obj.containerSlotIndex);
            buf.method_10814(obj.descriptionId);
            buf.method_10814(obj.contentId);
            buf.method_10812(obj.blockId);
        }

        @Override
        public ContainerLocationObject read(class_2540 buf) {
            class_2338 blockPos = this.readPosSafe(buf);
            int slotIndex = buf.readInt();
            boolean priority = buf.readBoolean();
            int containerSlotIndex = buf.readInt();
            String descriptionId = buf.method_19772();
            String containerId = buf.method_19772();
            class_2960 blockId = buf.method_10810();
            return new ContainerLocationObject(blockPos, slotIndex, priority, containerSlotIndex, descriptionId, containerId, blockId);
        }
    };

    @Override
    public class_2960 type() {
        return TYPE;
    }

    @Override
    public boolean isValid(class_3218 level) {
        class_2586 blockEntity;
        boolean loaded = level.method_8477(this.blockPos);
        if (!loaded) {
            return true;
        }
        class_2248 block = level.method_8320(this.blockPos).method_26204();
        boolean sameBlock = class_7923.field_41175.method_10223(this.blockId).equals(block);
        if (sameBlock && (blockEntity = level.method_8321(this.blockPos)) != null) {
            class_1792 item = Platform.PLATFORM.getContainerItemByIndex(this.containerSlotIndex, blockEntity);
            return Objects.equals(item.method_7876(), this.contentId);
        }
        return sameBlock;
    }

    @Override
    public ILocationObject copy(class_2338 blockPos, int slotIndex, boolean priority, String descriptionId) {
        return new ContainerLocationObject(blockPos, slotIndex, priority, this.containerSlotIndex, descriptionId, this.contentId, this.blockId);
    }

    @Override
    public Optional<ILocationObject> update(class_3218 level) {
        return Optional.of(this);
    }

    @Override
    public String toString() {
        return "Block Container Entity [" + this.descriptionId + ": " + this.contentId + "], " + String.valueOf(this.blockPos) + (this.priority ? " [priority]" : "");
    }
}

