/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.compat.lootr;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.SearchOptions;
import com.nine.travelerscompass.common.search.criterion.ISearchCriterion;
import com.nine.travelerscompass.common.search.criterion.TypedCriteria;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.LootrContainerLocationObject;
import com.nine.travelerscompass.common.search.location.LootrMinecartLocationObject;
import com.nine.travelerscompass.compat.lootr.LootrSearchMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import noobanidus.mods.lootr.common.api.data.DefaultLootFiller;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.data.DataStorage;
import noobanidus.mods.lootr.common.entity.LootrChestMinecartEntity;

public class FabricLootrHelper {
    public static List<ILocationObject> minecartMatch(TypedCriteria criteria, SearchOptions options, class_1297 entity, class_1937 level, class_2338 pos) {
        ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
        if (entity instanceof LootrChestMinecartEntity) {
            LootrChestMinecartEntity minecart = (LootrChestMinecartEntity)entity;
            if (criteria.itemCriteria.isEmpty()) {
                return List.of();
            }
            if (!FabricLootrHelper.shouldCheckLootrContainer((ILootrInfoProvider)minecart, options)) {
                return ret;
            }
            ILootrInventory inventory = DataStorage.getInventory((ILootrInfoProvider)minecart, (class_3222)options.player(), (LootFiller)DefaultLootFiller.getInstance());
            if (inventory != null) {
                String id = entity.method_5864().method_5882();
                for (class_1799 stack : inventory.getInventoryContents()) {
                    class_1792 item = stack.method_7909();
                    if (!criteria.itemCriteriaMap.containsKey(item)) continue;
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ret.add(new LootrMinecartLocationObject(pos.method_10062(), criterion.slot(), criterion.priority(), id, item.method_7876(), entity.method_5667()));
                }
            }
        }
        return ret;
    }

    public static List<ILocationObject> matchLootrContainer(TypedCriteria criteria, SearchOptions options, class_2338 pos, class_2680 state, class_2586 be) {
        ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
        if (be instanceof ILootrBlockEntity) {
            ILootrBlockEntity lootEntity = (ILootrBlockEntity)be;
            if (criteria.itemCriteria.isEmpty()) {
                return List.of();
            }
            if (!FabricLootrHelper.shouldCheckLootrContainer((ILootrInfoProvider)lootEntity, options)) {
                return ret;
            }
            ILootrInventory inventory = DataStorage.getInventory((ILootrInfoProvider)lootEntity, (class_3222)options.player(), (LootFiller)DefaultLootFiller.getInstance());
            if (inventory != null) {
                class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
                for (class_1799 stack : inventory.getInventoryContents()) {
                    class_1792 item = stack.method_7909();
                    if (!criteria.itemCriteriaMap.containsKey(item)) continue;
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ret.add(new LootrContainerLocationObject(pos.method_10062(), criterion.slot(), criterion.priority(), 0, state.method_26204().method_63499(), item.method_7876(), id));
                }
            }
        }
        return ret;
    }

    public static boolean shouldCheckLootrContainer(ILootrInfoProvider iHasOpeners, SearchOptions options) {
        LootrSearchMode searchMode = options.get(CompassProperties.LOOTR_MODE);
        if (iHasOpeners.getActualOpeners() == null) {
            return false;
        }
        boolean opened = iHasOpeners.getActualOpeners().contains(options.getPlayerUUID());
        return switch (searchMode) {
            case LootrSearchMode.ALL -> true;
            case LootrSearchMode.OPENED -> opened;
            case LootrSearchMode.CLOSED -> {
                if (!opened) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

