/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.compat.modmenu;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nine.travelerscompass.TCCommon;
import com.nine.travelerscompass.compat.modmenu.TCUpdateInfo;
import com.nine.travelerscompass.compat.modmenu.VersionUpdateData;
import com.terraformersmc.modmenu.api.UpdateChannel;
import com.terraformersmc.modmenu.api.UpdateChecker;
import com.terraformersmc.modmenu.api.UpdateInfo;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_155;
import net.minecraft.class_2561;

public class TCUpdateChecker
implements UpdateChecker {
    public UpdateInfo checkForUpdates() {
        JsonObject updateInfo = TCUpdateChecker.tryGetUrlInfo();
        if (updateInfo == null) {
            return TCUpdateInfo.NONE;
        }
        UpdateChannel preference = UpdateChannel.getUserPreference();
        List<VersionUpdateData> updateVersions = TCUpdateChecker.getUpdateVersions(class_155.method_16673().comp_4025(), updateInfo);
        VersionUpdateData update = null;
        String tempVersion = TCCommon.MOD_VERSION;
        for (VersionUpdateData ver : updateVersions) {
            if (TCUpdateChecker.compareVersions(tempVersion, ver.version()) >= 0) continue;
            if (ver.updateChannel() == UpdateChannel.RELEASE) {
                tempVersion = ver.version();
                update = ver;
            }
            if (ver.updateChannel() != preference) continue;
            tempVersion = ver.version();
            update = ver;
        }
        return update == null ? TCUpdateInfo.NONE : new TCUpdateInfo(true, (class_2561)class_2561.method_43470((String)update.version()), update.url(), update.updateChannel());
    }

    public static JsonObject tryGetUrlInfo() {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://raw.githubusercontent.com/0Templ/ModVersions/refs/heads/main/fabric/travelers-compass.json")).timeout(Duration.ofSeconds(10L)).GET().build();
            HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                JsonObject json = JsonParser.parseString((String)response.body()).getAsJsonObject();
                return json;
            }
        }
        catch (Exception e) {
            TCCommon.LOGGER.debug("Couldn't fetch update info{}", (Object)e.getMessage());
        }
        return null;
    }

    public static List<VersionUpdateData> getUpdateVersions(String mcVersion, JsonObject json) {
        ArrayList<VersionUpdateData> ret = new ArrayList<VersionUpdateData>();
        if (json.has(mcVersion)) {
            JsonObject versions = json.get(mcVersion).getAsJsonObject();
            try {
                for (Map.Entry el : versions.entrySet()) {
                    JsonObject data = ((JsonElement)el.getValue()).getAsJsonObject();
                    String url = data.get("url").getAsString();
                    String version = data.get("version").getAsString();
                    ret.add(new VersionUpdateData(UpdateChannel.valueOf((String)((String)el.getKey()).toUpperCase()), url, version));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static int compareVersions(String v1, String v2) {
        String[] splitV1 = v1.split("[.-]");
        String[] splitV2 = v2.split("[.-]");
        int len = Math.max(splitV1.length, splitV2.length);
        for (int i = 0; i < len; ++i) {
            String partV1 = i < splitV1.length ? splitV1[i] : "0";
            String partV2 = i < splitV2.length ? splitV2[i] : "0";
            boolean digitV1 = partV1.matches("\\d+");
            boolean digitV2 = partV2.matches("\\d+");
            int compared = digitV1 && digitV2 ? Integer.compare(Integer.parseInt(partV1), Integer.parseInt(partV2)) : TCUpdateChecker.compareChars(partV1, partV2);
            if (compared == 0) continue;
            return compared;
        }
        return 0;
    }

    public static int compareChars(String partV1, String partV2) {
        char[] charsV1 = partV1.toLowerCase().toCharArray();
        char[] charsV2 = partV2.toLowerCase().toCharArray();
        int charsLen = Math.max(charsV1.length, charsV2.length);
        for (int j = 0; j < charsLen; ++j) {
            int c2;
            char chV1 = j < charsV1.length ? charsV1[j] : (char)'0';
            char chV2 = j < charsV2.length ? charsV2[j] : (char)'0';
            int c1 = TCUpdateChecker.charToInt(chV1);
            if (c1 == (c2 = TCUpdateChecker.charToInt(chV2))) continue;
            return c1 > c2 ? 1 : -1;
        }
        return 0;
    }

    public static int charToInt(char c) {
        int ret = c;
        if (c >= 48 && c <= 57) {
            ret -= 48;
        }
        return ret;
    }
}

