/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.config.cost;

import com.nine.travelerscompass.TCCommon;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.config.cost.SearchCost;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class SearchCostHelper {
    static final int MAX_CACHE_SIZE = 500;
    public static final Map<class_1792, SearchCost> CACHED_ITEM_COSTS = new LinkedHashMap<class_1792, SearchCost>(500, 0.8f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry<class_1792, SearchCost> eldest) {
            return this.size() > 500;
        }
    };
    public static final Map<class_1792, SearchCost> ITEM_COSTS = new HashMap<class_1792, SearchCost>();
    public static final Map<String, SearchCost> TAG_COSTS = new HashMap<String, SearchCost>();

    public static SearchCost getCost(class_1792 item) {
        SearchCost cost = CACHED_ITEM_COSTS.get(item);
        if (cost != null) {
            return cost;
        }
        SearchCost ret = ITEM_COSTS.get(item);
        if (ret != null) {
            CACHED_ITEM_COSTS.put(item, ret);
            return ret;
        }
        List tags = item.method_40131().method_40228().toList();
        for (class_6862 tag : tags) {
            SearchCost searchCost = TAG_COSTS.get(tag.comp_327().toString());
            if (searchCost == null) continue;
            CACHED_ITEM_COSTS.put(item, searchCost);
            return searchCost;
        }
        CACHED_ITEM_COSTS.put(item, SearchCost.FREE);
        return SearchCost.FREE;
    }

    public static Map<String, SearchCost> fromConfig(List<String> list) {
        HashMap<String, SearchCost> ret = new HashMap<String, SearchCost>();
        for (String raw : list) {
            String[] split;
            String line = raw.trim();
            if (line.isEmpty() || (split = line.split("=", 2)).length != 2) continue;
            String id = split[0].trim();
            String[] costData = split[1].trim().split("/", 2);
            try {
                int cost = Integer.parseInt(costData[0]);
                int req = costData.length > 1 ? Integer.parseInt(costData[1]) : 0;
                ret.put(id, new SearchCost(cost, req));
            }
            catch (Exception e) {
                TCCommon.LOGGER.warn("Couldn't parse: {}", (Object)raw);
            }
        }
        return ret;
    }

    public static void updateCosts() {
        ITEM_COSTS.clear();
        TAG_COSTS.clear();
        CACHED_ITEM_COSTS.clear();
        for (Map.Entry<String, SearchCost> data : SearchCostHelper.fromConfig(TCConfig.ITEM_COSTS.get()).entrySet()) {
            class_2960 id = class_2960.method_60654((String)data.getKey());
            Optional optional = class_7923.field_41178.method_17966(id);
            optional.ifPresent(item -> ITEM_COSTS.put((class_1792)item, (SearchCost)data.getValue()));
        }
        for (Map.Entry<String, SearchCost> data : SearchCostHelper.fromConfig(TCConfig.ITEM_TAGS_COSTS.get()).entrySet()) {
            try {
                TAG_COSTS.put(data.getKey(), data.getValue());
            }
            catch (NumberFormatException e) {
                TCCommon.LOGGER.warn("Couldn't parse cost-tag: {}", data);
            }
        }
        CACHED_ITEM_COSTS.putAll(ITEM_COSTS);
    }

    public static boolean consumeXp(class_1657 player, class_1792 item) {
        SearchCost searchCost;
        if (TCConfig.SEARCH_REQUIRES_XP.get().booleanValue() && !player.method_68878() && !(searchCost = SearchCostHelper.getCost(item)).isFree()) {
            if (searchCost.meetsAllConditions(player.field_7520)) {
                player.method_17356(class_3417.field_14627, class_3419.field_15250, 0.25f, 1.0f);
                player.method_7316(-searchCost.costLevel());
                return true;
            }
            return false;
        }
        return true;
    }
}

