/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.platform;

import Shadow.shadow.nightconfig.core.UnmodifiableConfig;
import Shadow.shadow.nightconfig.core.file.CommentedFileConfig;
import com.nine.travelerscompass.config.ConfigSyncManager;
import com.nine.travelerscompass.config.ConfigType;
import com.nine.travelerscompass.config.ConfigValue;
import com.nine.travelerscompass.platform.IPlatformConfigHelper;
import java.io.File;
import net.fabricmc.loader.api.FabricLoader;

public class FabricPlatformConfigHelper
extends IPlatformConfigHelper {
    public static final CommentedFileConfig COMMON = (CommentedFileConfig)CommentedFileConfig.builder(FabricPlatformConfigHelper.getConfigPath("travelerscompass-common")).autosave().sync().preserveInsertionOrder().build();
    public static final CommentedFileConfig COST = (CommentedFileConfig)CommentedFileConfig.builder(FabricPlatformConfigHelper.getConfigPath("travelerscompass-cost")).autosave().sync().preserveInsertionOrder().build();

    @Override
    public ConfigValue<Integer> registerInt(String key, int defaultValue, int min, int max, ConfigValue.Section section, ConfigType type, boolean shouldSync, String comment) {
        return this.register(key, defaultValue, section, type, Integer.class, shouldSync, comment);
    }

    @Override
    public <T> ConfigValue<T> register(String key, T defaultValue, ConfigValue.Section section, ConfigType type, Class<T> clazz, boolean shouldSync, String comment) {
        FabricConfigValue<T> value;
        CommentedFileConfig config = this.getConfig(type);
        if (!config.contains((value = new FabricConfigValue<T>(config, key, defaultValue, section, type, clazz, shouldSync)).path())) {
            config.set(value.path(), value.defaultValue());
        }
        if (defaultValue.getClass().isEnum()) {
            Class<?> enumClass = defaultValue.getClass();
            ?[] values = enumClass.getEnumConstants();
            comment = (String)comment + "\nAvailable values: ";
            CharSequence[] names = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                names[i] = ((Enum)values[i]).name();
            }
            comment = (String)comment + String.join((CharSequence)", ", names);
        }
        config.setComment(value.path(), (String)comment);
        ConfigSyncManager.checkSyncable(value);
        return value;
    }

    private CommentedFileConfig getConfig(ConfigType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ConfigType.COST -> COST;
            case ConfigType.COMMON -> COMMON;
        };
    }

    @Override
    public <T> T get(ConfigValue<T> value) {
        return ((FabricConfigValue)value).config.get(value.path());
    }

    private static File getConfigPath(String id) {
        return FabricLoader.getInstance().getConfigDir().resolve(id + ".toml").toFile();
    }

    public static class FabricConfigValue<T>
    extends ConfigValue<T> {
        private final UnmodifiableConfig config;

        public FabricConfigValue(UnmodifiableConfig config, String key, T defaultValue, ConfigValue.Section section, ConfigType type, Class<T> clazz, boolean shouldSync) {
            super(key, defaultValue, section, type, clazz, shouldSync);
            this.config = config;
        }

        @Override
        public T get() {
            if (ConfigSyncManager.SYNCED_VALUES.containsKey(this.path())) {
                return (T)ConfigSyncManager.SYNCED_VALUES.get(this.path());
            }
            Object value = this.config.get(this.path());
            if (this.clazz != null && this.clazz.isEnum() && value instanceof String) {
                String str = (String)value;
                return Enum.valueOf(this.clazz, str);
            }
            return value;
        }
    }
}

