/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.platform;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.SearchOptions;
import com.nine.travelerscompass.common.search.criterion.ISearchCriterion;
import com.nine.travelerscompass.common.search.criterion.TypedCriteria;
import com.nine.travelerscompass.common.search.location.ContainerLocationObject;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.matcher.BlockEntityMatcher;
import com.nine.travelerscompass.common.search.matcher.BlockMatcher;
import com.nine.travelerscompass.common.search.matcher.EntityMatcher;
import com.nine.travelerscompass.compat.lootr.FabricLootrHelper;
import com.nine.travelerscompass.compat.lootr.LootrSearchMode;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.platform.IPlatformMatchersHelper;
import com.nine.travelerscompass.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_7923;

public class FabricPlatformMatchersHelper
implements IPlatformMatchersHelper {
    public static final EntityMatcher LOOTR_MINECART_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, class_1297 entity, class_1937 level, class_2338 pos) {
            return FabricLootrHelper.minecartMatch(criteria, options, entity, level, pos);
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return Platform.PLATFORM.isModLoaded("lootr") && options.get(CompassProperties.LOOTR_MODE) != LootrSearchMode.OFF;
        }
    };
    public static final BlockEntityMatcher LOOTR_CONTAINER_MATCHER = new BlockEntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, class_2338 pos, class_2680 state, class_2586 be) {
            return FabricLootrHelper.matchLootrContainer(criteria, options, pos, state, be);
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            if (!options.get(CompassProperties.CONTAINERS).booleanValue() || !TCConfig.ENABLE_BLOCK_CONTAINERS_SEARCH.get().booleanValue()) {
                return false;
            }
            return Platform.PLATFORM.isModLoaded("lootr") && options.get(CompassProperties.LOOTR_MODE) != LootrSearchMode.OFF;
        }
    };
    public static final BlockEntityMatcher CONTAINER_MATCHER = new BlockEntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, class_2338 pos, class_2680 state, class_2586 be) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (criteria.itemCriteria.isEmpty()) {
                return List.of();
            }
            Storage storage = (Storage)ItemStorage.SIDED.find(be.method_10997(), pos, state, be, null);
            if (storage == null) {
                return ret;
            }
            int index = -1;
            for (StorageView variantStorageView : storage) {
                class_1792 item;
                ++index;
                if (variantStorageView.isResourceBlank() || !criteria.itemCriteriaMap.containsKey(item = ((ItemVariant)variantStorageView.getResource()).getItem())) continue;
                ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                ret.add(new ContainerLocationObject(pos.method_10062(), criterion.slot(), criterion.priority(), index, state.method_26204().method_63499(), item.method_7876(), class_7923.field_41175.method_10221((Object)state.method_26204())));
            }
            return ret;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            if (!options.get(CompassProperties.CONTAINERS).booleanValue() || !TCConfig.ENABLE_BLOCK_CONTAINERS_SEARCH.get().booleanValue()) {
                return false;
            }
            return options.get(CompassProperties.BLOCK_CONTAINERS);
        }
    };

    @Override
    public List<BlockEntityMatcher> blockEntityMatchers() {
        return List.of(CONTAINER_MATCHER, LOOTR_CONTAINER_MATCHER);
    }

    @Override
    public List<BlockMatcher> blockMatchers() {
        return List.of();
    }

    @Override
    public List<EntityMatcher> entityMatchers() {
        return List.of(LOOTR_MINECART_MATCHER);
    }
}

