/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.BaseButton;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class SettingsButton
extends BaseButton {
    protected final Supplier<class_1799> supplier;
    private final DataStorage<?> data;
    private final Function<Object, DisplayDataHolder> displayDataProvider;
    public Object cachedValue;
    private DisplayDataHolder cachedDisplayData;

    public SettingsButton(int x, int y, int width, int height, DataStorage<?> data, Function<Object, DisplayDataHolder> displayDataProvider, Supplier<class_1799> supplier) {
        this(x, y, width, height, data, displayDataProvider, supplier, button -> {});
    }

    public SettingsButton(int x, int y, int width, int height, DataStorage<?> data, Function<Object, DisplayDataHolder> displayDataProvider, Supplier<class_1799> supplier, class_4185.class_4241 onPress) {
        super(x, y, width, height, onPress);
        this.data = data;
        this.displayDataProvider = displayDataProvider;
        this.supplier = supplier;
        this.updateState();
    }

    public void updateState() {
        class_1799 stack = this.supplier.get();
        this.cachedValue = this.data.get(stack);
        this.cachedDisplayData = this.displayDataProvider.apply(this.cachedValue);
    }

    public void method_25348(double mouseX, double mouseY) {
        class_1799 stack = this.supplier.get();
        CompassProperties.toggleFromClient(stack, this.data, true);
        this.updateState();
        this.refreshTooltip();
    }

    @Override
    public void onEnter() {
        this.updateState();
        this.refreshTooltip();
    }

    @Override
    protected void renderMainLayer(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        TextureData baseLayer = ClientData.TOGGLE_BUTTON.get(false, this.method_49606());
        ClientUtils.renderTexture(graphics, baseLayer, this.method_46426(), this.method_46427());
    }

    @Override
    public void renderIcon(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        IconTexture iconLayer = this.method_49606() ? this.cachedDisplayData.iconHovered : this.cachedDisplayData.icon;
        ClientUtils.renderTexture(graphics, iconLayer, this.method_46426(), this.method_46427());
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
        this.renderIcon(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void refreshTooltip() {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        String key = "tooltip.travelerscompass.settings." + this.data.getKey();
        class_5250 title = class_2561.method_43471((String)key);
        class_2561 state = this.cachedDisplayData.tooltipState;
        list.add((class_2561)title);
        if (this.shiftPressed) {
            list.add((class_2561)class_2561.method_43473().method_10852(ClientUtils.DESC_ARROW).method_10852((class_2561)class_2561.method_43471((String)(key + ".desc")).method_27692(class_124.field_1080)));
        }
        list.add(state);
        this.method_47400(class_7919.method_47407((class_2561)ClientUtils.buildTooltip(list)));
    }

    public record DisplayDataHolder(IconTexture icon, IconTexture iconHovered, class_2561 tooltipState) {
    }
}

