/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.hud;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.client.hud.type.IHudTypeRenderer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.utils.HudRenderMode;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.init.ItemRegistry;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_408;
import net.minecraft.class_746;

public class HudRenderer {
    public static final class_2960 TEXTURE = new class_2960("travelerscompass", "textures/gui/gui_components.png");
    public static final class_2960 EDGES_TEXTURE = new class_2960("travelerscompass", "textures/gui/hud_edges.png");
    private static final int EDGE_PADDING = 7;
    private static final int HEIGHT_PADDING = 2;
    private static final int WIDTH_PADDING = 2;
    static final class_310 minecraft = class_310.method_1551();
    private static int renderTicksCount = 0;

    public static void renderTick(class_332 graphics, float partialTicks) {
        class_746 player = HudRenderer.minecraft.field_1724;
        if (player != null) {
            if (player.field_6012 % 100 == 0) {
                HashSet<UUID> validUUIDs = new HashSet<UUID>();
                for (class_1799 stack : player.method_31548().field_7547) {
                    if (!stack.method_31574((class_1792)ItemRegistry.TRAVELERS_COMPASS.get())) continue;
                    UUID uuid2 = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
                    validUUIDs.add(uuid2);
                }
                ClientData.HUD_DATA_CACHE.keySet().removeIf(uuid -> !validUUIDs.contains(uuid));
            }
            if (!HudRenderer.shouldShow()) {
                return;
            }
            class_327 font = HudRenderer.minecraft.field_1772;
            for (HudData hudData : ClientData.HUD_DATA_CACHE.values()) {
                HudSettings settings = hudData.getSettings();
                if (settings.renderMode() == HudRenderMode.OFF || settings.renderMode() == HudRenderMode.HAND_ONLY && !hudData.isSelected() || HudRenderer.minecraft.field_1755 instanceof class_408 && !settings.hudWithChat() || HudRenderer.minecraft.field_1755 != null && !(HudRenderer.minecraft.field_1755 instanceof class_408)) continue;
                IHudTypeRenderer renderer = settings.hudType().renderer;
                graphics.method_51448().method_22903();
                graphics.method_51448().method_22905(settings.scale(), settings.scale(), 1.0f);
                renderer.render(graphics, (class_1657)player, font, hudData);
                graphics.method_51448().method_22909();
            }
        }
        if (player != null && renderTicksCount % 3000 == 0) {
            renderTicksCount = 0;
        }
    }

    public static void forceRender(class_332 graphics, float partialTicks, UUID uuid) {
        if (ClientData.HUD_DATA_CACHE.containsKey(uuid)) {
            HudData hudData = ClientData.HUD_DATA_CACHE.get(uuid);
            HudSettings settings = hudData.getSettings();
            IHudTypeRenderer renderer = settings.hudType().renderer;
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22905(settings.scale(), settings.scale(), 1.0f);
            renderer.render(graphics, (class_1657)HudRenderer.minecraft.field_1724, HudRenderer.minecraft.field_1772, hudData);
            HudRenderer.drawEdges(graphics, settings.xPos(), settings.yPos(), settings.width(), settings.height(), partialTicks);
            graphics.method_51448().method_22909();
        }
    }

    private static boolean shouldShow() {
        return TCConfig.ENABLE_HUD.get() != false && HudRenderer.minecraft.field_1687 != null && !HudRenderer.minecraft.field_1690.field_1842 && !HudRenderer.minecraft.field_1690.field_1866;
    }

    protected static void drawEdges(class_332 graphics, int xPos, int yPos, int width, int height, float partialTicks) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        float pulse = 0.8f + 0.2f * class_3532.method_15374((float)((partialTicks + (float)player.field_6012) * 0.1f));
        int padding = 7;
        graphics.method_51422(1.0f, 1.0f, 1.0f, pulse);
        graphics.method_25290(EDGES_TEXTURE, xPos, yPos, 0.0f, 0.0f, 7, 7, 14, 14);
        graphics.method_25290(EDGES_TEXTURE, xPos + width - 7 + 4, yPos, 7.0f, 0.0f, 7, 7, 14, 14);
        graphics.method_25290(EDGES_TEXTURE, xPos, yPos + height - 7 + 2, 0.0f, 7.0f, 7, 7, 14, 14);
        graphics.method_25290(EDGES_TEXTURE, xPos + width - 7 + 4, yPos + height - 7 + 2, 7.0f, 7.0f, 7, 7, 14, 14);
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

