/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.hud.type;

import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.client.hud.type.IHudTypeRenderer;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.utils.Alignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class CompactHudTypeRenderer
implements IHudTypeRenderer {
    public static final int MAX_LINES = 4;

    @Override
    public void render(class_332 graphics, class_1657 player, class_327 font, HudData hudData) {
        if (hudData.isDirty()) {
            int prefixWidth = font.method_27525((class_5348)class_2561.method_43469((String)"hud.travelerscompass.compact.target", (Object[])new Object[]{""}));
            hudData.updateCachedData(font, prefixWidth);
            hudData.clearDirty();
        }
        HudSettings settings = hudData.getSettings();
        int xPos = settings.xPos() + 2;
        int yPos = settings.yPos() + 2;
        int width = settings.width();
        int height = settings.height();
        ILocationObject locationObject = hudData.getLocationObject();
        boolean valid = locationObject != null;
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        class_5250 state = class_2561.method_43469((String)"hud.travelerscompass.compact.state", (Object[])new Object[]{hudData.getState()}).method_27692(class_124.field_1068);
        components.add((class_2561)state);
        if (valid) {
            class_5250 finalName = class_2561.method_43469((String)"hud.travelerscompass.compact.target", (Object[])new Object[]{hudData.getTargetName()}).method_27692(class_124.field_1068);
            components.add((class_2561)finalName);
            class_2338 blockPos = locationObject.blockPos();
            if (blockPos != null) {
                class_2561 position = CompactHudTypeRenderer.formatCoordsCompact(blockPos, font, width);
                class_5250 distance = class_2561.method_43469((String)"hud.travelerscompass.compact.distance", (Object[])new Object[]{ClientUtils.getDistance(player.method_24515(), blockPos)}).method_27692(class_124.field_1068);
                components.add(position);
                components.add((class_2561)distance);
            }
        }
        CompactHudTypeRenderer.drawCompactLines(graphics, font, xPos, yPos, width, height, settings.alignment(), 4, components);
    }

    public static void drawCompactLines(class_332 graphics, class_327 font, int xPos, int yPos, int width, int height, Alignment alignment, int maxLines, List<class_2561> components) {
        if (components.isEmpty()) {
            return;
        }
        Objects.requireNonNull(font);
        int linesHeight = maxLines * 9;
        int gap = components.size() > 1 ? (height - linesHeight) / (maxLines - 1) : 0;
        int currentY = yPos;
        for (class_2561 component : components) {
            int currentX = xPos;
            switch (alignment) {
                case LEFT: {
                    break;
                }
                case RIGHT: {
                    currentX += width - font.method_27525((class_5348)component);
                    break;
                }
                case CENTER: {
                    currentX += (width - font.method_27525((class_5348)component)) / 2;
                }
            }
            graphics.method_27535(font, component, currentX, currentY, 0xAAAAAA);
            Objects.requireNonNull(font);
            currentY += 9 + gap;
        }
    }

    public static class_2561 formatCoordsCompact(class_2338 pos, class_327 font, int maxWidth) {
        class_5250 coords = class_2561.method_43470((String)(pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260())).method_27692(class_124.field_1080);
        class_5250 full = class_2561.method_43469((String)"hud.travelerscompass.compact.position", (Object[])new Object[]{coords}).method_27692(class_124.field_1068);
        if (font.method_27525((class_5348)full) <= maxWidth) {
            return full;
        }
        coords = class_2561.method_43470((String)(pos.method_10263() + ", " + pos.method_10260())).method_27692(class_124.field_1080);
        full = class_2561.method_43469((String)"hud.travelerscompass.compact.position", (Object[])new Object[]{coords}).method_27692(class_124.field_1068);
        if (font.method_27525((class_5348)full) <= maxWidth) {
            return full;
        }
        coords = class_2561.method_43470((String)(pos.method_10263() + ", " + pos.method_10260())).method_27692(class_124.field_1080);
        full = class_2561.method_43469((String)"hud.travelerscompass.compact.position_short", (Object[])new Object[]{coords}).method_27692(class_124.field_1068);
        if (font.method_27525((class_5348)full) <= maxWidth) {
            return full;
        }
        coords = class_2561.method_43470((String)(ClientUtils.compressNumber(pos.method_10263()) + ", " + ClientUtils.compressNumber(pos.method_10260()))).method_27692(class_124.field_1080);
        full = class_2561.method_43469((String)"hud.travelerscompass.compact.position_short", (Object[])new Object[]{coords}).method_27692(class_124.field_1068);
        if (font.method_27525((class_5348)full) <= maxWidth) {
            return full;
        }
        return class_2561.method_43469((String)"hud.travelerscompass.compact.position_short", (Object[])new Object[]{class_2561.method_43470((String)"...").method_27692(class_124.field_1080)}).method_27692(class_124.field_1068);
    }
}

