/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.data;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.codec.DataCodec;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class DataStorage<T> {
    private final class_2960 id;
    private final Function<class_2487, String> keyResolver;
    private final Function<class_2487, T> defaultValue;
    private final Function<T, T> validator;
    private final DataCodec<T> codec;

    public DataStorage(class_2960 id, Function<class_2487, String> keyResolver, Function<class_2487, T> defaultValue, Function<T, T> validator, DataCodec<T> codec) {
        this.id = id;
        this.keyResolver = keyResolver;
        this.defaultValue = defaultValue;
        this.validator = validator;
        this.codec = codec;
    }

    public DataStorage(class_2960 id, String key, T defaultValue, DataCodec<T> codec) {
        this(id, tag -> key, tag -> defaultValue, t -> t, codec);
    }

    public DataStorage(class_2960 id, Function<class_2487, String> keyResolver, T defaultValue, DataCodec<T> codec) {
        this(id, keyResolver, tag -> defaultValue, t -> t, codec);
    }

    public String getKey(class_2487 tag) {
        return this.keyResolver.apply(tag);
    }

    public String getKey() {
        return this.getKey(null);
    }

    public DataCodec<T> getCodec() {
        return this.codec;
    }

    public class_2960 getId() {
        return this.id;
    }

    private static <T> boolean areSame(T a, T b) {
        return Objects.equals(a, b);
    }

    public void put(class_1799 stack, T value) {
        this.put(stack.method_7948(), value);
    }

    public void put(class_2487 tag, T value) {
        CompassProperties.put(tag, this, value);
    }

    public T get(class_1799 stack) {
        return this.get(stack.method_7948());
    }

    public T get(class_2487 tag) {
        return CompassProperties.get(tag, this);
    }

    public T read(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        return this.read(tag);
    }

    public T read(class_2487 tag) {
        if (!this.codec.exists(tag, this.getKey(tag))) {
            this.write(tag, this.getDefault(tag));
        }
        return this.codec.read(tag, this.getKey(tag));
    }

    public void write(class_2487 tag, T value) {
        this.codec.write(tag, this.getKey(tag), value);
    }

    public T getDefault(class_1799 stack) {
        return this.getDefault(stack.method_7948());
    }

    public T getDefault(class_2487 tag) {
        return this.defaultValue.apply(tag);
    }

    public T validate(T value) {
        return this.validator.apply(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof DataStorage)) return false;
        DataStorage other = (DataStorage)obj;
        if (!this.id.equals((Object)other.id)) return false;
        return true;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

