/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.utils;

import com.nine.travelerscompass.mixin.accessor.LootItemAccessor;
import com.nine.travelerscompass.mixin.accessor.LootPoolAccessor;
import com.nine.travelerscompass.platform.accessor.LootTableAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.server.MinecraftServer;

public class LootUtils {
    private static final Map<class_2960, Set<class_1792>> LOOT_CACHE = new HashMap<class_2960, Set<class_1792>>();

    public static List<class_55> getPools(class_52 lootTable) {
        return ((LootTableAccessor)lootTable).travelerscompass$getPools();
    }

    public static List<class_79> getEntries(class_55 lootPool) {
        return List.of(((LootPoolAccessor)lootPool).travelerscompass$entries());
    }

    public static List<class_77> getLootItems(class_52 lootTable) {
        ArrayList<class_77> dropList = new ArrayList<class_77>();
        LootUtils.getPools(lootTable).forEach(lootPool -> LootUtils.getEntries(lootPool).stream().filter(entry -> entry instanceof class_77).map(entry -> (class_77)entry).forEach(dropList::add));
        dropList.removeIf(Objects::isNull);
        return dropList;
    }

    public static Set<class_1792> getItemsFromLootTable(class_2960 location, class_1937 level) {
        if (LOOT_CACHE.containsKey(location)) {
            return LOOT_CACHE.get(location);
        }
        MinecraftServer server = level.method_8503();
        if (server != null) {
            class_52 lootTable = server.method_3857().getLootTable(location);
            HashSet dropStackList = new HashSet();
            LootUtils.getLootItems(lootTable).stream().map(lootItem -> ((LootItemAccessor)lootItem).travelerscompass$item()).forEach(dropStackList::add);
            LOOT_CACHE.put(location, dropStackList);
        }
        return LOOT_CACHE.getOrDefault(location, Set.of());
    }
}

