/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.TogglePopupButton;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class SearchModePopupButton
extends TogglePopupButton {
    protected final DataStorage<Boolean> data;
    protected final ItemStack stack;
    protected final IconTexture iconActive;
    protected final IconTexture iconInactive;
    protected final boolean enabled;

    protected SearchModePopupButton(int x, int y, ItemStack stack, boolean enabled, IconTexture iconActive, IconTexture iconInactive, TextureData popupConnector, TextureData popupTexture, DataStorage<Boolean> data, Rect2i mainRect, Rect2i popupRect) {
        super(x, y, 14, 14, ClientData.TOGGLE_BUTTON, popupConnector, popupTexture, mainRect, popupRect);
        this.stack = stack;
        this.enabled = enabled;
        this.data = data;
        this.iconActive = iconActive;
        this.iconInactive = iconInactive;
    }

    public void updateState() {
    }

    @Override
    protected boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void onMainButtonClick(int button) {
        CompassProperties.toggleToServer(this.stack, this.data);
        this.setToggled(this.data.get(this.stack));
    }

    @Override
    protected void afterClick(int button) {
        this.updateState();
        this.refreshTooltip();
    }

    @Override
    protected void renderMainLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        TextureData baseLayer = this.buttonTextures.get(this.toggled, this.isHovered, this.isEnabled());
        ClientUtils.renderTexture(graphics, baseLayer, this.getX(), this.getY());
    }

    @Override
    protected void renderIcon(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        IconTexture icon = this.isEnabled() ? (this.isActivated() ? this.iconActive : this.iconInactive) : new IconTexture(ClientData.LOCK, 3, 2);
        ClientUtils.renderTexture(graphics, icon, this.getX(), this.getY());
    }

    @Override
    public void refreshTooltip() {
        Component state;
        ArrayList<Component> list = new ArrayList<Component>();
        String key = "tooltip.travelerscompass.search_mode." + this.data.id();
        MutableComponent title = Component.translatable((String)key);
        list.add((Component)title);
        Component component = this.isToggled() ? (this.isActivated() ? ENABLED : INACTIVE) : (state = DISABLED);
        if (this.isEnabled()) {
            if (this.shiftPressed) {
                list.add((Component)Component.empty().append(ClientUtils.DESC_ARROW).append((Component)Component.translatable((String)(key + ".desc")).withStyle(ChatFormatting.GRAY)));
            }
        } else {
            state = CONFIG_DISABLED;
        }
        list.add(state);
        this.setTooltip(Tooltip.create((Component)ClientUtils.buildTooltip(list)));
    }
}

