/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.BaseButton;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class SettingsButton
extends BaseButton {
    protected final Supplier<ItemStack> supplier;
    private final DataStorage<?> data;
    private final Function<Object, DisplayDataHolder> displayDataProvider;
    public Object cachedValue;
    private DisplayDataHolder cachedDisplayData;

    public SettingsButton(int x, int y, int width, int height, DataStorage<?> data, Function<Object, DisplayDataHolder> displayDataProvider, Supplier<ItemStack> supplier) {
        this(x, y, width, height, data, displayDataProvider, supplier, button -> {});
    }

    public SettingsButton(int x, int y, int width, int height, DataStorage<?> data, Function<Object, DisplayDataHolder> displayDataProvider, Supplier<ItemStack> supplier, Button.OnPress onPress) {
        super(x, y, width, height, onPress);
        this.data = data;
        this.displayDataProvider = displayDataProvider;
        this.supplier = supplier;
        this.updateState();
    }

    public void updateState() {
        ItemStack stack = this.supplier.get();
        this.cachedValue = this.data.get(stack);
        this.cachedDisplayData = this.displayDataProvider.apply(this.cachedValue);
    }

    public void onClick(double mouseX, double mouseY) {
        ItemStack stack = this.supplier.get();
        CompassProperties.toggleToServer(stack, this.data, true);
        this.updateState();
        this.refreshTooltip();
    }

    @Override
    public void onEnter() {
        this.updateState();
        this.refreshTooltip();
    }

    @Override
    protected void renderMainLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        TextureData baseLayer = ClientData.TOGGLE_BUTTON.get(false, this.isHovered());
        ClientUtils.renderTexture(graphics, baseLayer, this.getX(), this.getY());
    }

    @Override
    public void renderIcon(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        IconTexture iconLayer = this.isHovered() ? this.cachedDisplayData.iconHovered : this.cachedDisplayData.icon;
        ClientUtils.renderTexture(graphics, iconLayer, this.getX(), this.getY());
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        this.renderIcon(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void refreshTooltip() {
        ArrayList<Component> list = new ArrayList<Component>();
        String key = "tooltip.travelerscompass.settings." + this.data.id();
        MutableComponent title = Component.translatable((String)key);
        Component state = this.cachedDisplayData.tooltipState;
        list.add((Component)title);
        if (this.shiftPressed) {
            list.add((Component)Component.empty().append(ClientUtils.DESC_ARROW).append((Component)Component.translatable((String)(key + ".desc")).withStyle(ChatFormatting.GRAY)));
        }
        list.add(state);
        this.setTooltip(Tooltip.create((Component)ClientUtils.buildTooltip(list)));
    }

    public record DisplayDataHolder(IconTexture icon, IconTexture iconHovered, Component tooltipState) {
    }
}

