/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.BaseButton;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.SearchProgress;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.utils.SearchState;
import com.nine.travelerscompass.network.packet.c2s.PausePacket;
import com.nine.travelerscompass.network.packet.c2s.WideSearchPacket;
import com.nine.travelerscompass.platform.Platform;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class WideSearchButton
extends BaseButton {
    private final Supplier<ItemStack> supplier;
    private final UUID uuid;

    public WideSearchButton(int x, int y, Supplier<ItemStack> supplier) {
        super(x, y, 14, 14);
        this.supplier = supplier;
        this.uuid = CompassProperties.COMPASS_UUID.get(supplier.get());
        this.refreshTooltip();
    }

    public void onClick(double mouseX, double mouseY) {
        ItemStack stack = this.supplier.get();
        if (CompassProperties.SEARCH_STATE.get(stack) == SearchState.WIDE_SEARCHING) {
            if (this.shiftPressed) {
                ClientData.PROGRESS_DATA_CACHE.put(this.uuid, new SearchProgress(0, 0));
                ClientData.PROGRESS_DATA_CACHE.remove(this.uuid);
                Platform.PLATFORM_NETWORK.sendToServer(new PausePacket(this.uuid));
                CompassProperties.SEARCH_STATE.set(stack, SearchState.IDLE);
                this.refreshTooltip();
            }
        } else {
            this.refreshTooltip();
            Platform.PLATFORM_NETWORK.sendToServer(new WideSearchPacket(this.uuid));
        }
    }

    @Override
    protected void renderIcon(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        TextureData iconLayer = this.isHovered() ? ClientData.WIDE_SEARCH_HOVERED : ClientData.WIDE_SEARCH_ICON;
        ClientUtils.renderTexture(graphics, iconLayer, this.getX() + 2, this.getY() + 2);
    }

    @Override
    protected void renderMainLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ItemStack stack;
        TextureData baseLayer = ClientData.TOGGLE_BUTTON.get(false, this.isHovered);
        ClientUtils.renderTexture(graphics, baseLayer, this.getX(), this.getY());
        this.renderIcon(graphics, mouseX, mouseY, partialTicks);
        SearchProgress searchProgress = ClientData.PROGRESS_DATA_CACHE.get(this.uuid);
        if (searchProgress != null && CompassProperties.SEARCH_STATE.get(stack = this.supplier.get()) == SearchState.WIDE_SEARCHING) {
            float progress = (float)searchProgress.progress / (float)searchProgress.total;
            this.drawProgress(graphics, this.getX() + 1, this.getY() + 12, 13, 1, progress, this.isHovered ? -1 : -1560281089);
        }
    }

    private void drawProgress(GuiGraphics g, int x, int y, int w, int h, float p, int fg) {
        float wf = p * (float)w;
        int full = Mth.floor((float)wf);
        if (full > 0) {
            g.fill(x, y, x + full, y + h, fg);
        }
    }

    @Override
    public void refreshTooltip() {
        ArrayList<Component> list = new ArrayList<Component>();
        String key = "tooltip.travelerscompass.wide_search";
        MutableComponent title = Component.translatable((String)key);
        list.add((Component)title);
        if (this.shiftPressed) {
            MutableComponent desc = ClientUtils.DESC_ARROW.copy().append((Component)Component.translatable((String)(key + ".desc")).withStyle(ChatFormatting.GRAY));
            list.add((Component)desc);
        }
        if (CompassProperties.SEARCH_STATE.get(this.supplier.get()) == SearchState.WIDE_SEARCHING) {
            SearchProgress searchProgress = ClientData.PROGRESS_DATA_CACHE.get(this.uuid);
            int percent = 0;
            if (searchProgress != null) {
                percent = searchProgress.progress * 100 / searchProgress.total;
            }
            MutableComponent progress = ClientUtils.coloredComponent(Component.literal((String)(percent + "%")), 0xC8C8C8);
            list.add((Component)Component.translatable((String)"tooltip.travelerscompass.settings.info.status.progress", (Object[])new Object[]{progress}).withStyle(ChatFormatting.GRAY));
            MutableComponent shiftRBM = ClientUtils.coloredComponent(Component.translatable((String)"tooltip.travelerscompass.settings.modification.shift_click"), 0xC8C8C8);
            list.add((Component)Component.translatable((String)"tooltip.travelerscompass.wide_search.cancel", (Object[])new Object[]{shiftRBM}).withStyle(ChatFormatting.GRAY));
        }
        this.setTooltip(Tooltip.create((Component)ClientUtils.buildTooltip(list)));
    }
}

