/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.hud;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.client.hud.type.IHudTypeRenderer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.utils.HudRenderMode;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.init.ItemRegistry;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HudRenderer {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"textures/gui/gui_components.png");
    public static final ResourceLocation EDGES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"textures/gui/hud_edges.png");
    private static final int EDGE_PADDING = 7;
    private static final int HEIGHT_PADDING = 2;
    private static final int WIDTH_PADDING = 2;
    static final Minecraft minecraft = Minecraft.getInstance();
    private static int renderTicksCount = 0;

    public static void renderTick(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        HudRenderer.renderTick(guiGraphics, deltaTracker.getGameTimeDeltaPartialTick(false));
    }

    public static void renderTick(GuiGraphics graphics, float partialTicks) {
        LocalPlayer player = HudRenderer.minecraft.player;
        if (player != null) {
            if (player.tickCount % 100 == 0) {
                HashSet<UUID> validUUIDs = new HashSet<UUID>();
                for (ItemStack stack : player.getInventory().items) {
                    if (!stack.is((Item)ItemRegistry.TRAVELERS_COMPASS.get())) continue;
                    UUID uuid2 = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
                    validUUIDs.add(uuid2);
                }
                ClientData.HUD_DATA_CACHE.keySet().removeIf(uuid -> !validUUIDs.contains(uuid));
            }
            if (!HudRenderer.shouldShow()) {
                return;
            }
            Font font = HudRenderer.minecraft.font;
            for (HudData hudData : ClientData.HUD_DATA_CACHE.values()) {
                HudSettings settings = hudData.getSettings();
                if (settings.renderMode() == HudRenderMode.OFF || settings.renderMode() == HudRenderMode.HAND_ONLY && !hudData.isSelected() || HudRenderer.minecraft.screen instanceof ChatScreen && !settings.hudWithChat() || HudRenderer.minecraft.screen != null && !(HudRenderer.minecraft.screen instanceof ChatScreen)) continue;
                IHudTypeRenderer renderer = settings.hudType().renderer;
                graphics.pose().pushPose();
                graphics.pose().scale(settings.scale(), settings.scale(), 1.0f);
                renderer.render(graphics, (Player)player, font, hudData);
                graphics.pose().popPose();
            }
        }
        if (player != null && renderTicksCount % 3000 == 0) {
            renderTicksCount = 0;
        }
    }

    public static void forceRender(GuiGraphics graphics, float partialTicks, UUID uuid) {
        if (ClientData.HUD_DATA_CACHE.containsKey(uuid)) {
            HudData hudData = ClientData.HUD_DATA_CACHE.get(uuid);
            HudSettings settings = hudData.getSettings();
            IHudTypeRenderer renderer = settings.hudType().renderer;
            graphics.pose().pushPose();
            graphics.pose().scale(settings.scale(), settings.scale(), 1.0f);
            renderer.render(graphics, (Player)HudRenderer.minecraft.player, HudRenderer.minecraft.font, hudData);
            HudRenderer.drawEdges(graphics, settings.xPos(), settings.yPos(), settings.width(), settings.height(), partialTicks);
            graphics.pose().popPose();
        }
    }

    private static boolean shouldShow() {
        return TCConfig.ENABLE_HUD.get() != false && HudRenderer.minecraft.level != null && !HudRenderer.minecraft.options.hideGui;
    }

    protected static void drawEdges(GuiGraphics graphics, int xPos, int yPos, int width, int height, float partialTicks) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        float pulse = 0.8f + 0.2f * Mth.sin((float)((partialTicks + (float)player.tickCount) * 0.1f));
        int padding = 7;
        graphics.setColor(1.0f, 1.0f, 1.0f, pulse);
        graphics.blit(EDGES_TEXTURE, xPos, yPos, 0.0f, 0.0f, 7, 7, 14, 14);
        graphics.blit(EDGES_TEXTURE, xPos + width - 7 + 4, yPos, 7.0f, 0.0f, 7, 7, 14, 14);
        graphics.blit(EDGES_TEXTURE, xPos, yPos + height - 7 + 2, 0.0f, 7.0f, 7, 7, 14, 14);
        graphics.blit(EDGES_TEXTURE, xPos + width - 7 + 4, yPos + height - 7 + 2, 7.0f, 7.0f, 7, 7, 14, 14);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

