/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.utils;

import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithContent;
import com.nine.travelerscompass.config.filter.FilterReason;
import com.nine.travelerscompass.platform.Platform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class ClientUtils {
    public static final int SOFT_GRAY = 0xC8C8C8;
    public static final int GRAY = 0xAAAAAA;
    public static final int HONEY = 13939050;
    public static final int SOFT_HONEY = 16176273;
    public static final int SOFT_GREEN = 11462271;
    public static final int SOFT_RED = 12077385;
    public static final float MAX_SCALE = 3.0f;
    public static final float MIN_SCALE = 0.3f;
    public static final ResourceLocation SPACE_HELPER = ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"space_helper");
    public static final Component DESC_ARROW_INDENT = Component.literal((String)"\uf820").withStyle(Style.EMPTY.withFont(SPACE_HELPER));
    public static final Component DESC_ARROW = ClientUtils.coloredComponent(Component.literal((String)"\u25b6").append(DESC_ARROW_INDENT), 0xC8C8C8);
    public static final Component DISABLED = Component.translatable((String)"tooltip.travelerscompass.disabled").withStyle(ChatFormatting.GRAY);
    public static final Component ENABLED = Component.translatable((String)"tooltip.travelerscompass.enabled").withStyle(ChatFormatting.GRAY);

    public static Component buildTooltip(Component title, Component ... toAppend) {
        MutableComponent ret = Component.empty().append(title);
        for (Component component : toAppend) {
            ret = ret.append((Component)Component.literal((String)"\n")).append(component);
        }
        return ret;
    }

    public static Component buildSearchModeTooltip(String titleKey, List<String> descKeys, boolean state) {
        return ClientUtils.buildToggleTooltip(titleKey, descKeys, ENABLED, DISABLED, state);
    }

    public static Component buildToggleTooltip(String titleKey, List<String> descKeys, Component enabled, Component disabled, boolean state) {
        List<Component> components = ClientUtils.buildToggleComponentsList(titleKey, descKeys, state ? enabled : disabled);
        return ClientUtils.buildTooltip(components);
    }

    public static Component buildSearchModeTooltip(String titleKey, List<String> descKeys, Component state) {
        List<Component> components = ClientUtils.buildToggleComponentsList(titleKey, descKeys, state);
        return ClientUtils.buildTooltip(components);
    }

    public static List<Component> buildToggleComponentsList(String titleKey, List<String> descKeys, boolean state) {
        return ClientUtils.buildToggleComponentsList(titleKey, descKeys, state ? ENABLED : DISABLED);
    }

    public static List<Component> buildToggleComponentsList(String titleKey, List<String> descKeys, Component enabled, Component disabled, boolean state) {
        return ClientUtils.buildToggleComponentsList(titleKey, descKeys, state ? enabled : disabled);
    }

    public static List<Component> buildToggleComponentsList(String titleKey, List<String> descKeys, Component state) {
        ArrayList<Component> ret = new ArrayList<Component>();
        ret.add((Component)Component.translatable((String)titleKey).withStyle(ChatFormatting.WHITE));
        if (descKeys != null) {
            for (String descKey : descKeys) {
                ret.add((Component)Component.empty().append(DESC_ARROW).append((Component)Component.translatable((String)descKey).withStyle(ChatFormatting.GRAY)));
            }
        }
        ret.add(state);
        return ret;
    }

    public static Component buildTooltip(List<Component> components) {
        if (components.isEmpty()) {
            return Component.empty();
        }
        Iterator<Component> iterator = components.iterator();
        MutableComponent ret = Component.empty().append(iterator.next());
        while (iterator.hasNext()) {
            ret = ret.append((Component)Component.literal((String)"\n")).append(iterator.next());
        }
        return ret;
    }

    public static MutableComponent coloredComponent(MutableComponent start, int color) {
        return start.withStyle(start.getStyle().withColor(color));
    }

    public static MutableComponent setColor(MutableComponent component, int color) {
        return component.withStyle(component.getStyle().withColor(color));
    }

    public static Component getDistance(BlockPos playerPos, BlockPos targetPos) {
        return Component.literal((String)String.valueOf((int)Math.sqrt(playerPos.distSqr((Vec3i)targetPos)))).withStyle(ChatFormatting.GRAY);
    }

    public static Component getLocationObjectTargetName(ILocationObject object) {
        int softColor;
        boolean priority = object.priority();
        int defaultColor = priority ? 13939050 : 0xAAAAAA;
        int n = softColor = priority ? 16176273 : 0xC8C8C8;
        if (object instanceof WithContent) {
            WithContent withContent = (WithContent)((Object)object);
            MutableComponent ret = Component.empty();
            ret.append((Component)ClientUtils.coloredComponent(Component.translatable((String)object.descriptionId()), defaultColor));
            ret.append((Component)ClientUtils.coloredComponent(Component.literal((String)" ["), defaultColor));
            ret.append((Component)ClientUtils.coloredComponent(Component.translatable((String)withContent.contentId()), softColor));
            ret.append((Component)ClientUtils.coloredComponent(Component.literal((String)"]"), defaultColor));
            return ret;
        }
        return ClientUtils.coloredComponent(Component.translatable((String)object.descriptionId()), defaultColor);
    }

    public static Component cutComponent(Font font, Component component, int availableWidth) {
        MutableComponent ret = Component.empty();
        MutableComponent dots = Component.literal((String)"...");
        int dotsWidth = font.width((FormattedText)dots);
        if (availableWidth <= font.width((FormattedText)dots)) {
            return dots;
        }
        int componentWidth = font.width((FormattedText)component);
        if (componentWidth <= availableWidth) {
            return component;
        }
        int widthUsed = 0;
        for (Component content : component.toFlatList()) {
            int contentWidth = font.width((FormattedText)content);
            if (widthUsed + contentWidth + dotsWidth <= availableWidth) {
                ret.append(content);
                widthUsed += contentWidth;
                continue;
            }
            String s = content.getString();
            if (widthUsed + dotsWidth >= availableWidth) {
                ret.append((Component)dots.withStyle(content.getStyle()));
                break;
            }
            MutableComponent formated = Component.literal((String)font.plainSubstrByWidth(s, availableWidth - widthUsed - dotsWidth)).withStyle(content.getStyle()).append((Component)dots.withStyle(content.getStyle()));
            ret.append((Component)formated);
            break;
        }
        return ret;
    }

    public static String compressNumber(int val) {
        int abs = Math.abs(val);
        if (abs >= 1000000) {
            return val / 1000000 + Component.translatable((String)"hud.travelerscompass.number.mega").getString();
        }
        if (abs >= 1000) {
            return val / 1000 + Component.translatable((String)"hud.travelerscompass.number.kilo").getString();
        }
        return String.valueOf(val);
    }

    public static Component formatReason(FilterReason reason) {
        if (reason instanceof FilterReason.ByModId) {
            FilterReason.ByModId byMod = (FilterReason.ByModId)reason;
            return Component.translatable((String)"tooltip.travelerscompass.config.filter_reason.mod", (Object[])new Object[]{Platform.PLATFORM.getModName(byMod.modId())}).withStyle(ChatFormatting.RED);
        }
        if (reason instanceof FilterReason.ByItemId) {
            return Component.translatable((String)"tooltip.travelerscompass.config.filter_reason.item").withStyle(ChatFormatting.RED);
        }
        if (reason instanceof FilterReason.ByTag) {
            FilterReason.ByTag byTag = (FilterReason.ByTag)reason;
            return Component.translatable((String)"tooltip.travelerscompass.config.filter_reason.tag", (Object[])new Object[]{byTag.tag().location().toString()}).withStyle(ChatFormatting.RED);
        }
        if (reason instanceof FilterReason.ByEntityType) {
            FilterReason.ByEntityType byEntityType = (FilterReason.ByEntityType)reason;
            Component entityName = byEntityType.type().getDescription();
            return Component.translatable((String)"tooltip.travelerscompass.config.filter_reason.entity", (Object[])new Object[]{entityName}).withStyle(ChatFormatting.RED);
        }
        return Component.empty();
    }

    public static void renderTexture(GuiGraphics graphics, IconTexture iconTexture, int x, int y) {
        ClientUtils.renderTexture(graphics, iconTexture.textureData(), x + iconTexture.xOffset(), y + iconTexture.yOffset());
    }

    public static void renderTexture(GuiGraphics graphics, TextureData data, int x, int y) {
        graphics.blit(data.getLocation(), x, y, data.getRenderWidth(), data.getRenderHeight(), (float)data.getU(), (float)data.getV(), data.getWidth(), data.getHeight(), data.getTextureWidth(), data.getTextureHeight());
    }
}

