/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.criterion;

import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.criterion.BlockCriterion;
import com.nine.travelerscompass.common.search.criterion.EntityCriterion;
import com.nine.travelerscompass.common.search.criterion.FluidCriterion;
import com.nine.travelerscompass.common.search.criterion.IPlaceableCriterion;
import com.nine.travelerscompass.common.search.criterion.ISearchCriterion;
import com.nine.travelerscompass.common.search.criterion.ItemCriterion;
import com.nine.travelerscompass.mixin.accessor.BucketItemAccessor;
import com.nine.travelerscompass.platform.accessor.MobBucketItemAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class TypedCriteria {
    public final Set<EntityCriterion> entityCriteria;
    public final Set<ItemCriterion> itemCriteria;
    public final Set<FluidCriterion> fluidCriteria;
    public final Set<BlockCriterion> blockCriteria;
    public final Map<Item, ISearchCriterion> itemCriteriaMap;
    public final Set<Block> placeableBlocks;

    public TypedCriteria(List<ISearchCriterion> criteria) {
        this.entityCriteria = TypedCriteria.quickFill(criteria, EntityCriterion.class);
        this.itemCriteria = TypedCriteria.quickFill(criteria, ItemCriterion.class);
        this.fluidCriteria = TypedCriteria.quickFill(criteria, FluidCriterion.class);
        this.blockCriteria = TypedCriteria.quickFill(criteria, BlockCriterion.class);
        this.itemCriteriaMap = TypedCriteria.criteriaToMap(criteria);
        this.placeableBlocks = criteria.stream().filter(c -> c instanceof IPlaceableCriterion).map(c -> ((IPlaceableCriterion)((Object)c)).asBlock()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static <T> Set<T> quickFill(List<ISearchCriterion> list, Class<T> type) {
        return list.stream().filter(type::isInstance).map(type::cast).collect(Collectors.toSet());
    }

    private static Map<Item, ISearchCriterion> criteriaToMap(List<? extends ISearchCriterion> list) {
        HashMap<Item, ISearchCriterion> searchItemsMap = new HashMap<Item, ISearchCriterion>();
        for (ISearchCriterion iSearchCriterion : list) {
            if (!(iSearchCriterion instanceof ItemCriterion)) continue;
            ItemCriterion itemCriterion = (ItemCriterion)iSearchCriterion;
            searchItemsMap.put(itemCriterion.item(), iSearchCriterion);
        }
        return searchItemsMap;
    }

    public static List<ISearchCriterion> extractCriteria(CompassContainer container, ItemStack stack) {
        List<Integer> array = CompassProperties.get(stack, CompassProperties.PRIORITY_SLOTS);
        ArrayList<ISearchCriterion> ret = new ArrayList<ISearchCriterion>();
        HashSet<Integer> priorSlots = new HashSet<Integer>();
        for (int slot : array) {
            priorSlots.add(slot);
        }
        for (int i = 0; i < container.getContainerSize(); ++i) {
            BucketItem bucketItem;
            Fluid fluid;
            ItemStack cStack = container.getItem(i);
            Item item = cStack.getItem();
            if (item instanceof AirItem) continue;
            boolean prior = priorSlots.contains(i);
            ret.add(new ItemCriterion(item, prior, i));
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                ret.add(new BlockCriterion(blockItem.getBlock(), prior, i));
            }
            if (item instanceof BucketItem && (fluid = ((BucketItemAccessor)(bucketItem = (BucketItem)item)).travelerscompass$content()) != null) {
                ret.add(new FluidCriterion(fluid, prior, i));
            }
            if (item instanceof SpawnEggItem) {
                SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                ret.add(new EntityCriterion(spawnEggItem.getType(spawnEggItem.getDefaultInstance()), prior, i));
            }
            if (!(item instanceof MobBucketItem)) continue;
            MobBucketItem mobBucketItem = (MobBucketItem)item;
            EntityType<?> type = ((MobBucketItemAccessor)mobBucketItem).travelerscompass$getType();
            ret.add(new EntityCriterion(type, prior, i));
        }
        return ret;
    }
}

