/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.network.packet.c2s;

import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.search.SearchManager;
import com.nine.travelerscompass.network.packet.c2s.C2SPacket;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public record WideSearchPacket(UUID uuid) implements C2SPacket
{
    public static final CustomPacketPayload.Type<WideSearchPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"wide_search_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, WideSearchPacket> PACKET_CODEC = StreamCodec.ofMember(WideSearchPacket::encode, WideSearchPacket::decode);

    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
    }

    public static WideSearchPacket decode(RegistryFriendlyByteBuf buf) {
        return new WideSearchPacket(buf.readUUID());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void handle(ServerPlayer player) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof TravelersCompassItem && Objects.equals(CompassProperties.COMPASS_UUID.get(stack), this.uuid)) {
            SearchManager.startWideSearch(stack, player, CompassContainer.container(stack));
        }
    }
}

