/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.platform;

import com.mojang.serialization.Codec;
import com.nine.travelerscompass.common.data.DataStorage;
import com.nine.travelerscompass.common.item.ForgeTravelersCompassItem;
import com.nine.travelerscompass.init.ForgeRegistryObject;
import com.nine.travelerscompass.init.MenuRegistry;
import com.nine.travelerscompass.init.RegistryProvider;
import com.nine.travelerscompass.platform.IPlatformRegistryHelper;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ForgePlatformRegistryHelper
implements IPlatformRegistryHelper {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"travelerscompass");
    public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"travelerscompass");
    public static final DeferredRegister<CreativeModeTab> TAB = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"travelerscompass");
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"travelerscompass");

    @Override
    public RegistryProvider<Item> registerTravelersCompassItem(String id, Item.Properties properties) {
        return this.registerItem(id, () -> new ForgeTravelersCompassItem(properties));
    }

    @Override
    public RegistryProvider<Item> registerItem(String name, Supplier<Item> itemSupplier) {
        return new ForgeRegistryObject<Item>(ITEMS.register(name, itemSupplier));
    }

    @Override
    public <T extends AbstractContainerMenu> RegistryProvider<MenuType<T>> registerMenu(String id, MenuRegistry.CommonMenuFactory<T> menuType) {
        RegistryObject ret = MENUS.register(id, () -> IForgeMenuType.create((windowId, inv, data) -> menuType.create(windowId, inv)));
        return new ForgeRegistryObject<MenuType<T>>(ret);
    }

    @Override
    public <T> DataStorage<T> registerDataComponent(String id, byte networkId, Supplier<T> defaultSupplier, Function<T, T> validator, Codec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec, boolean cacheEncoding) {
        RegistryObject holder = DATA_COMPONENTS.register(id, () -> {
            DataComponentType.Builder builder = DataComponentType.builder().persistent(codec);
            if (streamCodec != null) {
                builder.networkSynchronized(streamCodec);
            }
            if (cacheEncoding) {
                builder.cacheEncoding();
            }
            return builder.build();
        });
        return new DataStorage<T>(id, networkId, defaultSupplier, validator, new ForgeRegistryObject(holder));
    }

    @Override
    public RegistryProvider<CreativeModeTab> registerCreativeTab(String id, CreativeModeTab.Builder builder) {
        RegistryObject tab = TAB.register(id, () -> ((CreativeModeTab.Builder)builder).build());
        return new ForgeRegistryObject<CreativeModeTab>(tab);
    }
}

