/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.BaseButton;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.SearchProgress;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.utils.FoundBlockPos;
import com.nine.travelerscompass.common.utils.SearchState;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class InfoButton
extends BaseButton {
    private final Supplier<ItemStack> supplier;
    private final UUID uuid;

    public InfoButton(int x, int y, int width, int height, Supplier<ItemStack> supplier) {
        super(x, y, width, height);
        this.supplier = supplier;
        this.uuid = CompassProperties.COMPASS_UUID.get(supplier.get());
        this.refreshTooltip();
    }

    @Override
    public void refreshTooltip() {
        MutableComponent status;
        MutableComponent title = Component.m_237115_((String)"tooltip.travelerscompass.settings.info");
        ArrayList<Component> components = new ArrayList<Component>();
        ItemStack stack = this.supplier.get();
        FoundBlockPos pos = CompassProperties.FOUND_BLOCK_POS.get(stack);
        SearchState state = CompassProperties.SEARCH_STATE.get(stack);
        if (CompassProperties.PAUSE.get(stack).booleanValue()) {
            status = Component.m_237115_((String)"tooltip.travelerscompass.settings.info.status.paused").m_130940_(ChatFormatting.GRAY);
        } else if (state == SearchState.SEARCHING) {
            SearchProgress searchProgress = ClientData.PROGRESS_DATA_CACHE.get(this.uuid);
            int percent = 0;
            if (searchProgress != null) {
                percent = searchProgress.progress * 100 / searchProgress.total;
            }
            MutableComponent progress = ClientUtils.coloredComponent(Component.m_237113_((String)(percent + "%")), 0xC8C8C8);
            status = pos.isValid() ? Component.m_237110_((String)"tooltip.travelerscompass.settings.info.status.scanning", (Object[])new Object[]{progress}).m_130940_(ChatFormatting.GRAY) : Component.m_237110_((String)"tooltip.travelerscompass.settings.info.status.searching", (Object[])new Object[]{progress}).m_130940_(ChatFormatting.GRAY);
        } else {
            status = Component.m_237115_((String)"tooltip.travelerscompass.settings.info.status.idle").m_130940_(ChatFormatting.GRAY);
        }
        MutableComponent statusFull = Component.m_237110_((String)"tooltip.travelerscompass.settings.info.status", (Object[])new Object[]{status});
        components.add((Component)title);
        components.add((Component)statusFull);
        HudData data = ClientData.HUD_DATA_CACHE.get(CompassProperties.COMPASS_UUID.get(stack));
        ILocationObject locationObject = data.getLocationObject();
        if (pos.isValid() && locationObject != null) {
            MutableComponent target = Component.m_237110_((String)"tooltip.travelerscompass.settings.info.target", (Object[])new Object[]{Component.m_237115_((String)locationObject.descriptionId()).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.WHITE);
            components.add((Component)target);
            if (locationObject.blockPos() != null) {
                BlockPos blockPos = pos.blockPos();
                MutableComponent position = Component.m_237110_((String)"tooltip.travelerscompass.settings.info.position", (Object[])new Object[]{Component.m_237113_((String)(blockPos.m_123341_() + ", " + blockPos.m_123342_() + ", " + blockPos.m_123343_())).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.WHITE);
                components.add((Component)position);
            }
        }
        this.m_257544_(Tooltip.m_257550_((Component)ClientUtils.buildTooltip(components)));
    }

    @Override
    protected void renderMainLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ClientUtils.renderTexture(graphics, ClientData.TOGGLE_BUTTON.get(false, this.m_274382_()), this.m_252754_(), this.m_252907_());
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_87963_(graphics, mouseX, mouseY, partialTicks);
        ClientUtils.renderTexture(graphics, this.m_274382_() ? ClientData.INFO_HOVERED : ClientData.INFO, this.m_252754_() + 4, this.m_252907_() + 3);
    }
}

