/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.element;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.element.NewSearchModePopupElement;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import com.nine.travelerscompass.compat.lootr.LootrSearchMode;
import com.nine.travelerscompass.config.TCConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class LootrPopupElement
extends NewSearchModePopupElement {
    private final ItemStack stack;
    private final DataStorage<LootrSearchMode> data = CompassProperties.LOOTR_MODE;
    private final LootrSearchMode.ConfigMode configMode;
    private final List<LootrSearchMode> availableModes = new ArrayList<LootrSearchMode>();
    private LootrSearchMode currentSearchMode;
    private static final IconTexture LOOTR_ALL = new IconTexture(ClientData.LOOTR_ALL, 1, 1);
    private static final IconTexture LOOTR_CLOSED = new IconTexture(ClientData.LOOTR_CLOSED, 1, 1);
    private static final IconTexture LOOTR_OPENED = new IconTexture(ClientData.LOOTR_OPENED, 1, 1);
    private static final IconTexture LOOTR_INACTIVE = new IconTexture(ClientData.LOOTR_INACTIVE, 1, 1);

    public LootrPopupElement(int width, int height, ItemStack stack) {
        super(width, height, TCConfig.ENABLE_LOOTR_SEARCH.get(), null, null, null, stack);
        this.configMode = TCConfig.LOOTR_SEARCH.get();
        this.stack = stack;
        this.currentSearchMode = CompassProperties.LOOTR_MODE.get(stack);
        switch (this.configMode) {
            case ALL: {
                this.availableModes.add(LootrSearchMode.OFF);
                this.availableModes.add(LootrSearchMode.ALL);
                this.availableModes.add(LootrSearchMode.CLOSED);
                this.availableModes.add(LootrSearchMode.OPENED);
                break;
            }
            case CLOSED: {
                this.availableModes.add(LootrSearchMode.OFF);
                this.availableModes.add(LootrSearchMode.CLOSED);
                break;
            }
            case OPENED: {
                this.availableModes.add(LootrSearchMode.OFF);
                this.availableModes.add(LootrSearchMode.OPENED);
            }
        }
    }

    @Override
    protected TextureData getBaseLayer() {
        return this.buttonTextures.get(this.toggled, this.isHovered, this.active);
    }

    @Override
    public void refreshTooltip() {
        Object key = "tooltip.travelerscompass.toggle_element.lootr";
        ArrayList<Component> components = new ArrayList<Component>();
        MutableComponent title = Component.m_237115_((String)key);
        components.add((Component)title);
        key = (String)key + "." + this.currentSearchMode.key();
        MutableComponent state = Component.m_237115_((String)key).m_130940_(ChatFormatting.GRAY);
        if (this.shiftPressed) {
            components.add((Component)Component.m_237119_().m_7220_(ClientUtils.DESC_ARROW).m_7220_((Component)Component.m_237115_((String)((String)key + ".desc")).m_130940_(ChatFormatting.GRAY)));
        }
        components.add((Component)state);
        this.setTooltip(components);
    }

    @Override
    protected IconTexture getIconTexture() {
        return switch (this.currentSearchMode) {
            default -> throw new IncompatibleClassChangeError();
            case LootrSearchMode.ALL -> LOOTR_ALL;
            case LootrSearchMode.CLOSED -> LOOTR_CLOSED;
            case LootrSearchMode.OPENED -> LOOTR_OPENED;
            case LootrSearchMode.OFF -> LOOTR_INACTIVE;
        };
    }

    @Override
    public void onClick(int button) {
        LootrSearchMode searchMode = this.data.get(this.stack);
        int currentIndex = this.availableModes.indexOf((Object)searchMode);
        LootrSearchMode next = this.availableModes.get((currentIndex + 1) % this.availableModes.size());
        CompassProperties.putFromClient(this.stack, this.data, next);
        this.setToggleState();
    }

    @Override
    public void setToggleState() {
        LootrSearchMode current;
        this.currentSearchMode = current = this.data.get(this.stack);
        this.setToggled(!current.equals((Object)LootrSearchMode.OFF));
    }
}

