/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.hud.type;

import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.client.hud.type.IHudTypeRenderer;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.utils.Alignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class CompactHudTypeRenderer
implements IHudTypeRenderer {
    public static final int MAX_LINES = 4;

    @Override
    public void render(GuiGraphics graphics, Player player, Font font, HudData hudData) {
        if (hudData.isDirty()) {
            int prefixWidth = font.m_92852_((FormattedText)Component.m_237110_((String)"hud.travelerscompass.compact.target", (Object[])new Object[]{""}));
            hudData.updateCachedData(font, prefixWidth);
            hudData.clearDirty();
        }
        HudSettings settings = hudData.getSettings();
        int xPos = settings.xPos() + 2;
        int yPos = settings.yPos() + 2;
        int width = settings.width();
        int height = settings.height();
        ILocationObject locationObject = hudData.getLocationObject();
        boolean valid = locationObject != null;
        ArrayList<Component> components = new ArrayList<Component>();
        MutableComponent state = Component.m_237110_((String)"hud.travelerscompass.compact.state", (Object[])new Object[]{hudData.getState()}).m_130940_(ChatFormatting.WHITE);
        components.add((Component)state);
        if (valid) {
            MutableComponent finalName = Component.m_237110_((String)"hud.travelerscompass.compact.target", (Object[])new Object[]{hudData.getTargetName()}).m_130940_(ChatFormatting.WHITE);
            components.add((Component)finalName);
            BlockPos blockPos = locationObject.blockPos();
            if (blockPos != null) {
                Component position = CompactHudTypeRenderer.formatCoordsCompact(blockPos, font, width);
                MutableComponent distance = Component.m_237110_((String)"hud.travelerscompass.compact.distance", (Object[])new Object[]{ClientUtils.getDistance(player.m_20183_(), blockPos)}).m_130940_(ChatFormatting.WHITE);
                components.add(position);
                components.add((Component)distance);
            }
        }
        CompactHudTypeRenderer.drawCompactLines(graphics, font, xPos, yPos, width, height, settings.alignment(), 4, components);
    }

    public static void drawCompactLines(GuiGraphics graphics, Font font, int xPos, int yPos, int width, int height, Alignment alignment, int maxLines, List<Component> components) {
        if (components.isEmpty()) {
            return;
        }
        Objects.requireNonNull(font);
        int linesHeight = maxLines * 9;
        int gap = components.size() > 1 ? (height - linesHeight) / (maxLines - 1) : 0;
        int currentY = yPos;
        for (Component component : components) {
            int currentX = xPos;
            switch (alignment) {
                case LEFT: {
                    break;
                }
                case RIGHT: {
                    currentX += width - font.m_92852_((FormattedText)component);
                    break;
                }
                case CENTER: {
                    currentX += (width - font.m_92852_((FormattedText)component)) / 2;
                }
            }
            graphics.m_280430_(font, component, currentX, currentY, 0xAAAAAA);
            Objects.requireNonNull(font);
            currentY += 9 + gap;
        }
    }

    public static Component formatCoordsCompact(BlockPos pos, Font font, int maxWidth) {
        MutableComponent coords = Component.m_237113_((String)(pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_())).m_130940_(ChatFormatting.GRAY);
        MutableComponent full = Component.m_237110_((String)"hud.travelerscompass.compact.position", (Object[])new Object[]{coords}).m_130940_(ChatFormatting.WHITE);
        if (font.m_92852_((FormattedText)full) <= maxWidth) {
            return full;
        }
        coords = Component.m_237113_((String)(pos.m_123341_() + ", " + pos.m_123343_())).m_130940_(ChatFormatting.GRAY);
        full = Component.m_237110_((String)"hud.travelerscompass.compact.position", (Object[])new Object[]{coords}).m_130940_(ChatFormatting.WHITE);
        if (font.m_92852_((FormattedText)full) <= maxWidth) {
            return full;
        }
        coords = Component.m_237113_((String)(pos.m_123341_() + ", " + pos.m_123343_())).m_130940_(ChatFormatting.GRAY);
        full = Component.m_237110_((String)"hud.travelerscompass.compact.position_short", (Object[])new Object[]{coords}).m_130940_(ChatFormatting.WHITE);
        if (font.m_92852_((FormattedText)full) <= maxWidth) {
            return full;
        }
        coords = Component.m_237113_((String)(ClientUtils.compressNumber(pos.m_123341_()) + ", " + ClientUtils.compressNumber(pos.m_123343_()))).m_130940_(ChatFormatting.GRAY);
        full = Component.m_237110_((String)"hud.travelerscompass.compact.position_short", (Object[])new Object[]{coords}).m_130940_(ChatFormatting.WHITE);
        if (font.m_92852_((FormattedText)full) <= maxWidth) {
            return full;
        }
        return Component.m_237110_((String)"hud.travelerscompass.compact.position_short", (Object[])new Object[]{Component.m_237113_((String)"...").m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.WHITE);
    }
}

