/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.data;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.codec.DataCodec;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class DataStorage<T> {
    private final ResourceLocation id;
    private final Function<CompoundTag, String> keyResolver;
    private final Function<CompoundTag, T> defaultValue;
    private final Function<T, T> validator;
    private final DataCodec<T> codec;

    public DataStorage(ResourceLocation id, Function<CompoundTag, String> keyResolver, Function<CompoundTag, T> defaultValue, Function<T, T> validator, DataCodec<T> codec) {
        this.id = id;
        this.keyResolver = keyResolver;
        this.defaultValue = defaultValue;
        this.validator = validator;
        this.codec = codec;
    }

    public DataStorage(ResourceLocation id, String key, T defaultValue, DataCodec<T> codec) {
        this(id, tag -> key, tag -> defaultValue, t -> t, codec);
    }

    public DataStorage(ResourceLocation id, Function<CompoundTag, String> keyResolver, T defaultValue, DataCodec<T> codec) {
        this(id, keyResolver, tag -> defaultValue, t -> t, codec);
    }

    public String getKey(CompoundTag tag) {
        return this.keyResolver.apply(tag);
    }

    public String getKey() {
        return this.getKey(null);
    }

    public DataCodec<T> getCodec() {
        return this.codec;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    private static <T> boolean areSame(T a, T b) {
        return Objects.equals(a, b);
    }

    public void put(ItemStack stack, T value) {
        this.put(stack.m_41784_(), value);
    }

    public void put(CompoundTag tag, T value) {
        CompassProperties.put(tag, this, value);
    }

    public T get(ItemStack stack) {
        return this.get(stack.m_41784_());
    }

    public T get(CompoundTag tag) {
        return CompassProperties.get(tag, this);
    }

    public T read(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return this.read(tag);
    }

    public T read(CompoundTag tag) {
        if (!this.codec.exists(tag, this.getKey(tag))) {
            this.write(tag, this.getDefault(tag));
        }
        return this.codec.read(tag, this.getKey(tag));
    }

    public void write(CompoundTag tag, T value) {
        this.codec.write(tag, this.getKey(tag), value);
    }

    public T getDefault(ItemStack stack) {
        return this.getDefault(stack.m_41784_());
    }

    public T getDefault(CompoundTag tag) {
        return this.defaultValue.apply(tag);
    }

    public T validate(T value) {
        return this.validator.apply(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof DataStorage)) return false;
        DataStorage other = (DataStorage)obj;
        if (!this.id.equals((Object)other.id)) return false;
        return true;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

