/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.item;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.SearchManager;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithUUID;
import com.nine.travelerscompass.common.utils.FoundBlockPos;
import com.nine.travelerscompass.common.utils.HeightAttitude;
import com.nine.travelerscompass.common.utils.PriorityMode;
import com.nine.travelerscompass.common.utils.SearchState;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import com.nine.travelerscompass.platform.Platform;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class TravelersCompassItem
extends Item {
    public static final int STATE_EMPTY = 1;
    public static final int STATE_SEARCHING = 2;

    public TravelersCompassItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        CompassContainer compassContainer = CompassContainer.container(stack);
        Vec3 lookVector = player.m_20154_();
        Vec3 eyePosition = player.m_20299_(1.0f);
        Vec3 traceEnd = eyePosition.m_82520_(lookVector.f_82479_ * 5.0, lookVector.f_82480_ * 5.0, lookVector.f_82481_ * 5.0);
        BlockHitResult hitResult = level.m_45547_(new ClipContext(eyePosition, traceEnd, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        BlockPos blockPos = hitResult.m_82425_();
        if (!level.f_46443_) {
            ItemStack clickedStack;
            if (player.m_6144_() && !compassContainer.hasAny(clickedStack = level.m_8055_(blockPos).m_60734_().m_5456_().m_7968_())) {
                compassContainer.setItem(compassContainer.getFirstEmptySlot(), clickedStack, player);
                if (FilterManager.passesFilters(clickedStack)) {
                    level.m_5594_(null, player.m_20097_(), SoundEvents.f_12107_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
                }
            }
            UUID uuid = CompassProperties.COMPASS_UUID.get(stack);
            SearchManager.addWatcher(uuid, player.m_20148_());
            Platform.PLATFORM.openMenu(player, stack);
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity living, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_9236_().f_46443_ && player.m_6144_() && living instanceof Mob) {
            EntityType type;
            FilterReason reason;
            ItemStack eggStack;
            Mob mob = (Mob)living;
            SpawnEggItem eggItem = SpawnEggItem.m_43213_((EntityType)mob.m_6095_());
            CompassContainer compassContainer = CompassContainer.container(stack);
            if (eggItem != null && !compassContainer.hasAny(eggStack = eggItem.m_7968_()) && (reason = FilterManager.getFilterReason(type = eggItem.m_43228_(null))) instanceof FilterReason.Allowed) {
                compassContainer.setItem(compassContainer.getFirstEmptySlot(), eggStack, player);
                player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_12107_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            UUID uuid = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
            if (level.f_46443_) {
                if (!ClientData.HUD_DATA_CACHE.containsKey(uuid)) {
                    ClientData.HUD_DATA_CACHE.put(uuid, new HudData(new HudSettings(CompassProperties.HUD_RENDER_MODE.get(stack), CompassProperties.HUD_TYPE.get(stack), CompassProperties.HUD_ALIGNMENT.get(stack), CompassProperties.HUD_WITH_CHAT.get(stack), CompassProperties.HUD_SCALE.get(stack).floatValue(), CompassProperties.HUD_WIDTH.get(stack), CompassProperties.HUD_HEIGHT.get(stack), CompassProperties.HUD_X_POS.get(stack), CompassProperties.HUD_Y_POS.get(stack)), CompassProperties.PAUSE.get(stack), selected, CompassProperties.SEARCH_STATE.get(stack)));
                } else {
                    ClientData.HUD_DATA_CACHE.computeIfPresent(uuid, (id, hudData) -> {
                        hudData.setSelected(selected);
                        return hudData;
                    });
                    if (player.f_19797_ % 20 == 0) {
                        ClientData.HUD_DATA_CACHE.computeIfPresent(uuid, (id, hudData) -> {
                            hudData.setSearchState(CompassProperties.SEARCH_STATE.get(stack));
                            return hudData;
                        });
                    }
                }
            }
            if (!level.f_46443_ && player instanceof ServerPlayer) {
                boolean validLocation;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                boolean searching = SearchManager.inQueue(uuid);
                if (!searching && !CompassContainer.container(stack).m_7983_()) {
                    this.tryToScan(stack, serverPlayer, uuid);
                }
                PriorityMode priorityMode = CompassProperties.PRIORITY_MODE.get(stack);
                ILocationObject locationObject = SearchManager.getClosestLocation(player.m_20183_(), uuid, priorityMode);
                boolean bl = validLocation = locationObject != null;
                if (player.f_19797_ % 5 == 0) {
                    UUID targetUUID;
                    String targetID;
                    FoundBlockPos foundBlockPos;
                    CompassContainer container = CompassContainer.container(stack);
                    if (player.f_19797_ % 20 == 0) {
                        SearchState searchState = CompassProperties.SEARCH_STATE.get(stack);
                        if (!searching && searchState != SearchState.IDLE) {
                            CompassProperties.putFromServer(stack, serverPlayer, CompassProperties.SEARCH_STATE, SearchState.IDLE);
                        }
                        if (container.m_7983_()) {
                            SearchManager.clearFoundBlocks(uuid);
                        }
                        SearchManager.validatePositions(level, uuid);
                        SearchManager.validatePriority(stack);
                        if (TCConfig.ENABLE_HUD.get().booleanValue()) {
                            ILocationObject clientLocationObject = locationObject;
                            if (clientLocationObject != null && !TCConfig.SHOW_COORDS.get().booleanValue()) {
                                clientLocationObject = clientLocationObject.withBlockPos(null);
                            }
                            Platform.PLATFORM_NETWORK.sendS2CHudLocationDataPacket(serverPlayer, clientLocationObject, uuid);
                        }
                    }
                    if (!validLocation) {
                        CompassProperties.put(stack, CompassProperties.PRIORITY_ITEM_FOUND, Boolean.valueOf(false));
                        foundBlockPos = new FoundBlockPos();
                    } else {
                        foundBlockPos = new FoundBlockPos(locationObject.blockPos(), true);
                        CompassProperties.put(stack, CompassProperties.PRIORITY_ITEM_FOUND, Boolean.valueOf(locationObject.priority()));
                    }
                    this.updateState(stack, validLocation, container.m_7983_());
                    String string = targetID = validLocation ? locationObject.descriptionId() : "";
                    if (validLocation && locationObject instanceof WithUUID) {
                        WithUUID withUUID = (WithUUID)((Object)locationObject);
                        v2 = withUUID.uuid();
                    } else {
                        v2 = targetUUID = Util.f_137441_;
                    }
                    if (validLocation && !CompassProperties.FOUND_BLOCK_POS.get(stack).equals(foundBlockPos) && CompassProperties.SOUND_PING.get(stack).booleanValue()) {
                        boolean shouldPing = false;
                        if (!targetUUID.equals(CompassProperties.TARGET_UUID.get(stack))) {
                            shouldPing = true;
                        }
                        if (!targetID.isEmpty() && !targetID.equals(CompassProperties.TARGET_ID.get(stack))) {
                            shouldPing = true;
                        }
                        if (shouldPing) {
                            this.playPingSound(locationObject, player);
                        }
                    }
                    CompassProperties.put(stack, CompassProperties.TARGET_ID, targetID);
                    CompassProperties.put(stack, CompassProperties.TARGET_UUID, targetUUID);
                    CompassProperties.put(stack, CompassProperties.FOUND_BLOCK_POS, foundBlockPos);
                }
                this.updateTargetAttitude(stack, player.m_20183_(), locationObject);
            }
        }
    }

    private void playPingSound(ILocationObject locationObject, Player player) {
        Level level = player.m_9236_();
        if (locationObject.priority()) {
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.3f, 0.3f);
        }
        level.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.44f + level.f_46441_.m_188501_() / 10.0f);
        level.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 1.0f);
    }

    private void updateState(ItemStack stack, boolean validLocation, boolean empty) {
        int currentState = CompassProperties.COMPASS_STATE.get(stack);
        int newState = 1;
        if (validLocation) {
            newState = -1;
        } else if (CompassProperties.SEARCH_STATE.get(stack) != SearchState.IDLE) {
            newState = 2;
        } else if (CompassProperties.PAUSE.get(stack).booleanValue()) {
            newState = 1;
        } else if (!empty) {
            newState = 2;
        }
        if (currentState != newState) {
            CompassProperties.COMPASS_STATE.put(stack, (Integer)newState);
        }
    }

    private void updateTargetAttitude(ItemStack stack, BlockPos playerPos, ILocationObject locationData) {
        HeightAttitude heightAttitude;
        HeightAttitude current = CompassProperties.TARGET_HEIGHT.get(stack);
        if (locationData == null) {
            heightAttitude = HeightAttitude.NONE;
        } else {
            int tY;
            BlockPos targetPos = locationData.blockPos();
            int pY = playerPos.m_123342_();
            heightAttitude = pY - (tY = targetPos.m_123342_()) > 0 ? HeightAttitude.DOWN : (pY - tY <= -2 ? HeightAttitude.UP : HeightAttitude.SAME);
        }
        if (current != heightAttitude) {
            CompassProperties.put(stack, CompassProperties.TARGET_HEIGHT, heightAttitude);
        }
    }

    private void tryToScan(ItemStack stack, ServerPlayer player, UUID uuid) {
        if (!CompassProperties.get(stack, CompassProperties.PAUSE).booleanValue()) {
            int cooldown = CompassProperties.SEARCH_COOLDOWN.get(stack);
            if (cooldown > 0) {
                CompassProperties.put(stack, CompassProperties.SEARCH_COOLDOWN, Integer.valueOf(cooldown - 1));
            }
            if (cooldown <= 0) {
                CompassContainer container = CompassContainer.container(stack);
                if (container.m_7983_()) {
                    CompassProperties.put(stack, CompassProperties.SEARCH_COOLDOWN, Integer.valueOf(20));
                    return;
                }
                CompassProperties.put(stack, CompassProperties.SEARCH_COOLDOWN, TCConfig.SEARCH_INTERVAL.get());
                CompassProperties.putFromServer(stack, player, CompassProperties.SEARCH_STATE, SearchState.SEARCHING);
                SearchManager.startSearch(stack, player, container, false, result -> {
                    CompassProperties.putFromServer(stack, player, CompassProperties.SEARCH_STATE, SearchState.IDLE);
                    PriorityMode priorityMode = CompassProperties.PRIORITY_MODE.get(stack);
                    SearchManager.validatePriority(stack);
                    SearchManager.saveClosest(result.get(), player.m_20183_(), uuid, TCConfig.MAX_CACHED_LOCATIONS.get(), priorityMode);
                    SearchManager.validatePositions(player.m_9236_(), uuid);
                });
            }
        }
    }

    public static FoundBlockPos getFoundPos(ItemStack stack) {
        return CompassProperties.FOUND_BLOCK_POS.get(stack);
    }
}

