/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search;

import com.nine.travelerscompass.common.search.ChunkIterator;
import com.nine.travelerscompass.common.search.SearchManager;
import com.nine.travelerscompass.common.search.SearchOptions;
import com.nine.travelerscompass.common.search.SearchResult;
import com.nine.travelerscompass.common.search.criterion.TypedCriteria;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.matcher.BlockEntityMatcher;
import com.nine.travelerscompass.common.search.matcher.BlockMatcher;
import com.nine.travelerscompass.common.search.matcher.EntityMatcher;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.phys.AABB;

public class SearchProcess {
    private volatile boolean isAsyncRunning;
    private final AtomicBoolean canceled = new AtomicBoolean(false);
    final List<BlockMatcher> blockMatchers;
    final List<BlockEntityMatcher> blockEntityMatchers;
    final List<EntityMatcher> entityMatchers;
    final SearchOptions options;
    final TypedCriteria criteria;
    public final boolean allowChunkGen;
    public final boolean wideSearch;
    public final Level level;
    final BlockPos playerPos;
    final Queue<ChunkPos> deferredChunks = new ArrayDeque<ChunkPos>();
    private final ChunkIterator chunkIterator;
    int lastSyncedProgress;
    public final int chunksToScan;
    public int chunksPassed = 0;
    public int chunksPassedLastTick = 0;
    public int chunksLoaded = 0;
    int chunksLoadedLastTick = 0;
    public int chunksForceLoaded = 0;
    public int chunksForceLoadedLastTick = 0;
    final int entitiesSearchRange;
    public final SearchResult result = new SearchResult();
    public final Consumer<SearchResult> onComplete;

    public SearchProcess(Player player, boolean allowChunkGen, SearchOptions options, TypedCriteria criteria, List<BlockMatcher> bMatchers, List<BlockEntityMatcher> beMatchers, List<EntityMatcher> eMatchers, Consumer<SearchResult> onComplete) {
        this.allowChunkGen = allowChunkGen;
        this.wideSearch = options.wideSearch();
        this.level = player.m_9236_();
        this.criteria = criteria;
        this.options = options;
        this.entitiesSearchRange = options.getEntitiesSearchRange();
        this.playerPos = player.m_20183_();
        this.blockMatchers = bMatchers;
        this.blockEntityMatchers = beMatchers;
        this.entityMatchers = eMatchers;
        this.onComplete = onComplete;
        this.chunksToScan = (int)Math.pow(1 + options.getChunksSearchRange() * 2, 2.0);
        this.chunkIterator = new ChunkIterator(this.playerPos, options.getChunksSearchRange());
    }

    public void scanEntities() {
        AABB aabb = new AABB(this.playerPos.m_7918_(-this.entitiesSearchRange, -this.entitiesSearchRange, -this.entitiesSearchRange), this.playerPos.m_7918_(this.entitiesSearchRange, this.entitiesSearchRange, this.entitiesSearchRange));
        List list = this.level.m_45976_(Entity.class, aabb);
        if (this.entityMatchers.isEmpty()) {
            return;
        }
        for (Entity entity : list) {
            FilterReason filterReason = FilterManager.getFilterReason(entity.m_6095_());
            if (!(filterReason instanceof FilterReason.Allowed)) continue;
            for (EntityMatcher matcher : this.entityMatchers) {
                List<ILocationObject> data = matcher.match(this.criteria, this.options, entity, this.level, entity.m_20183_());
                if (data == null) continue;
                this.result.addAll(data);
            }
        }
    }

    public boolean tickAsync(int chunksLimit, int generationLimit) {
        if (this.isAsyncRunning || chunksLimit == 0) {
            return false;
        }
        MinecraftServer server = this.level.m_7654_();
        if (server == null || this.canceled.get()) {
            return true;
        }
        this.chunksPassedLastTick = 0;
        this.chunksForceLoadedLastTick = 0;
        this.chunksLoadedLastTick = 0;
        ArrayList<ChunkAccess> chunkList = new ArrayList<ChunkAccess>();
        while (this.chunkIterator.hasNext()) {
            boolean force;
            ++this.chunksPassed;
            ++this.chunksPassedLastTick;
            ChunkPos pos = this.chunkIterator.next();
            boolean chunkLoaded = this.level.m_7232_(pos.f_45578_, pos.f_45579_);
            boolean bl = force = this.allowChunkGen && !chunkLoaded && generationLimit > 0 && this.chunksForceLoadedLastTick <= generationLimit;
            if (force || chunkLoaded) {
                ChunkAccess chunkAccess = this.level.m_6522_(pos.f_45578_, pos.f_45579_, ChunkStatus.f_62326_, force);
                ++this.chunksLoaded;
                ++this.chunksLoadedLastTick;
                if (force) {
                    ++this.chunksForceLoaded;
                    ++this.chunksForceLoadedLastTick;
                }
                if (chunkAccess != null) {
                    chunkList.add(chunkAccess);
                }
            } else if (this.allowChunkGen && this.wideSearch) {
                this.deferredChunks.add(pos);
            }
            if (this.chunksPassedLastTick < chunksLimit) continue;
            break;
        }
        if (this.wideSearch && this.allowChunkGen && this.chunksLoadedLastTick < chunksLimit) {
            int lim = chunksLimit - chunkList.size();
            while (lim > 0 && !this.deferredChunks.isEmpty()) {
                boolean force;
                ChunkPos pos = this.deferredChunks.peek();
                boolean loaded = this.level.m_7232_(pos.f_45578_, pos.f_45579_);
                boolean bl = force = generationLimit > 0 && this.chunksForceLoadedLastTick < generationLimit;
                if (!loaded && force) break;
                ChunkAccess currentChunk = this.level.m_6522_(pos.f_45578_, pos.f_45579_, ChunkStatus.f_62326_, !loaded);
                if (currentChunk == null) break;
                this.deferredChunks.poll();
                chunkList.add(currentChunk);
                --lim;
                if (!loaded) {
                    ++this.chunksForceLoaded;
                    ++this.chunksForceLoadedLastTick;
                }
                ++this.chunksLoaded;
                ++this.chunksLoadedLastTick;
            }
        }
        ArrayList blockEntityPositions = new ArrayList();
        this.isAsyncRunning = true;
        CompletableFuture.supplyAsync(() -> {
            ArrayList<ILocationObject> localDataList = new ArrayList<ILocationObject>();
            for (ChunkAccess chunkAccess : chunkList) {
                LevelChunkSection[] sections = chunkAccess.m_7103_();
                int minSectionY = chunkAccess.m_151560_();
                int baseX = chunkAccess.m_7697_().f_45578_ << 4;
                int baseZ = chunkAccess.m_7697_().f_45579_ << 4;
                blockEntityPositions.addAll(chunkAccess.m_5928_());
                for (int s = 0; s < sections.length; ++s) {
                    PalettedContainer palette;
                    boolean shouldScanBlocks;
                    LevelChunkSection section = sections[s];
                    if (section == null || section.m_188008_() || !(shouldScanBlocks = (palette = section.m_63019_()).m_63109_(state -> this.criteria.placeableBlocks.contains(state.m_60734_())))) continue;
                    int baseY = minSectionY + s << 4;
                    BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            for (int y = 0; y < 16; ++y) {
                                BlockState state2 = section.m_62982_(x, y, z);
                                if (state2.m_60795_()) continue;
                                for (BlockMatcher matcher : this.blockMatchers) {
                                    mutablePos.m_122178_(baseX + x, baseY + y, baseZ + z);
                                    ILocationObject data = matcher.match(this.criteria, mutablePos.m_7949_(), state2);
                                    if (data == null) continue;
                                    localDataList.add(data);
                                }
                            }
                        }
                    }
                }
            }
            return localDataList;
        }).thenAcceptAsync(threadResult -> server.execute(() -> {
            if (this.canceled.get()) {
                this.isAsyncRunning = false;
                return;
            }
            try {
                for (BlockPos pos : blockEntityPositions) {
                    BlockState state = this.level.m_8055_(pos);
                    BlockEntity be = this.level.m_7702_(pos);
                    if (be == null) continue;
                    for (BlockEntityMatcher matcher : this.blockEntityMatchers) {
                        List<ILocationObject> data = matcher.match(this.criteria, this.options, pos, state, be);
                        if (data == null) continue;
                        this.result.addAll(data);
                    }
                }
                this.result.addAll((List<ILocationObject>)threadResult);
            }
            finally {
                this.isAsyncRunning = false;
            }
        }), (Executor)SearchManager.SCAN_EXECUTOR);
        return this.chunksPassed >= this.chunksToScan && !this.canScanAboveLimit() || this.canceled.get();
    }

    private boolean canScanAboveLimit() {
        return this.wideSearch && this.allowChunkGen && !this.deferredChunks.isEmpty();
    }

    public void setCanceled() {
        this.canceled.set(true);
    }

    public boolean shouldSyncProgress() {
        int current = this.chunksPassed * 100 / this.chunksToScan;
        if (current != this.lastSyncedProgress || this.chunksToScan <= this.chunksPassed) {
            this.lastSyncedProgress = current;
            return true;
        }
        return false;
    }
}

