/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.location;

import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithContent;
import com.nine.travelerscompass.common.search.location.WithUUID;
import com.nine.travelerscompass.common.search.location.codec.LocationCodec;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public record LootrMinecartLocationObject(BlockPos blockPos, int slotIndex, boolean priority, String descriptionId, String contentId, UUID uuid) implements ILocationObject,
WithContent,
WithUUID
{
    public static ResourceLocation TYPE = new ResourceLocation("travelerscompass", "lootr_minecart_location_codec");
    public static final LocationCodec<LootrMinecartLocationObject> CODEC = new LocationCodec<LootrMinecartLocationObject>(){

        @Override
        public void write(FriendlyByteBuf buf, LootrMinecartLocationObject obj) {
            this.writePosSafe(buf, obj.blockPos);
            buf.writeInt(obj.slotIndex);
            buf.writeBoolean(obj.priority);
            buf.m_130070_(obj.descriptionId);
            buf.m_130070_(obj.contentId);
            buf.m_130077_(obj.uuid);
        }

        @Override
        public LootrMinecartLocationObject read(FriendlyByteBuf buf) {
            BlockPos blockPos = this.readPosSafe(buf);
            int slotIndex = buf.readInt();
            boolean priority = buf.readBoolean();
            String descriptionId = buf.m_130277_();
            String contentId = buf.m_130277_();
            UUID uuid = buf.m_130259_();
            return new LootrMinecartLocationObject(blockPos, slotIndex, priority, descriptionId, contentId, uuid);
        }
    };

    @Override
    public ResourceLocation type() {
        return TYPE;
    }

    @Override
    public boolean isValid(ServerLevel level) {
        return level.m_8791_(this.uuid) != null;
    }

    @Override
    public ILocationObject copy(BlockPos blockPos, int slotIndex, boolean priority, String descriptionId) {
        return new LootrMinecartLocationObject(blockPos, slotIndex, priority, descriptionId, this.contentId, this.uuid);
    }

    @Override
    public Optional<ILocationObject> update(ServerLevel level) {
        Entity entity = level.m_8791_(this.uuid);
        if (entity != null && !entity.m_20183_().equals((Object)this.blockPos)) {
            return Optional.of(new LootrMinecartLocationObject(entity.m_20183_(), this.slotIndex, this.priority, this.descriptionId, this.contentId, this.uuid));
        }
        return Optional.of(this);
    }

    @Override
    public String toString() {
        return "Lootr Container Entity [" + this.descriptionId + ": " + this.contentId + "], " + String.valueOf(this.blockPos) + (this.priority ? " [priority]" : "");
    }
}

