/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.matcher;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.SearchOptions;
import com.nine.travelerscompass.common.search.criterion.BlockCriterion;
import com.nine.travelerscompass.common.search.criterion.EntityCriterion;
import com.nine.travelerscompass.common.search.criterion.FluidCriterion;
import com.nine.travelerscompass.common.search.criterion.ISearchCriterion;
import com.nine.travelerscompass.common.search.criterion.ItemCriterion;
import com.nine.travelerscompass.common.search.criterion.TypedCriteria;
import com.nine.travelerscompass.common.search.location.BlockLocationObject;
import com.nine.travelerscompass.common.search.location.ContainerEntityLocationObject;
import com.nine.travelerscompass.common.search.location.EntityLocationObject;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.SpawnerLocationObject;
import com.nine.travelerscompass.common.search.matcher.BlockEntityMatcher;
import com.nine.travelerscompass.common.search.matcher.BlockMatcher;
import com.nine.travelerscompass.common.search.matcher.EntityMatcher;
import com.nine.travelerscompass.common.utils.LootUtils;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.mixin.accessor.BaseSpawnerAccessor;
import com.nine.travelerscompass.platform.Platform;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class PositionMatchers {
    public static final BlockEntityMatcher CONTAINER_MATCHER = Platform.PLATFORM_MATCHERS.containerMatcher();
    public static final BlockEntityMatcher LOOTR_CONTAINER_MATCHER = Platform.PLATFORM_MATCHERS.lootrContainerMatcher();
    public static final EntityMatcher LOOTR_MINECART_MATCHER = Platform.PLATFORM_MATCHERS.lootrMinecartMatcher();
    public static final BlockMatcher BLOCK_MATCHER = new BlockMatcher(){

        @Override
        public ILocationObject match(TypedCriteria criteria, BlockPos pos, BlockState state) {
            Block block = state.m_60734_();
            for (BlockCriterion criterion : criteria.blockCriteria) {
                if (!criterion.check(block)) continue;
                ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)block);
                return new BlockLocationObject(pos, criterion.slot(), criterion.priority(), block.m_49954_().getString(), id);
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.BLOCKS) != false && TCConfig.ENABLE_BLOCKS_SEARCH.get() != false;
        }
    };
    public static final BlockMatcher FLUID_MATCHER = new BlockMatcher(){

        @Override
        public ILocationObject match(TypedCriteria criteria, BlockPos pos, BlockState state) {
            Block block = state.m_60734_();
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                Fluid fluid = liquidBlock.m_5888_(state).m_76152_();
                for (FluidCriterion criterion : criteria.fluidCriteria) {
                    if (!criterion.check(fluid)) continue;
                    ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)block);
                    return new BlockLocationObject(pos.m_7949_(), criterion.slot(), criterion.priority(), state.m_60734_().m_7705_(), id);
                }
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.FLUIDS) != false && TCConfig.ENABLE_FLUIDS_SEARCH.get() != false;
        }
    };
    public static final BlockEntityMatcher SPAWNER_MATCHER = new BlockEntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, BlockPos pos, BlockState state, BlockEntity be) {
            CompoundTag compoundtag;
            Optional optional;
            SpawnerBlockEntity spawnerBlockEntity;
            SpawnData spawndata;
            Block block = state.m_60734_();
            if (be instanceof SpawnerBlockEntity && (spawndata = ((BaseSpawnerAccessor)(spawnerBlockEntity = (SpawnerBlockEntity)be).m_59801_()).travelerscompass$nextSpawnData()) != null && (optional = EntityType.m_20637_((CompoundTag)(compoundtag = spawndata.m_186567_()))).isPresent()) {
                EntityType entityType = (EntityType)optional.get();
                for (EntityCriterion criterion : criteria.entityCriteria) {
                    if (!criterion.check(entityType)) continue;
                    ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)block);
                    return List.of(new SpawnerLocationObject(pos.m_7949_(), criterion.slot(), criterion.priority(), state.m_60734_().m_7705_(), entityType.m_20675_(), id));
                }
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.SPAWNERS) != false && TCConfig.ENABLE_SPAWNERS_SEARCH.get() != false;
        }
    };
    public static final EntityMatcher MINECART_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof AbstractMinecartContainer) {
                AbstractMinecartContainer minecart = (AbstractMinecartContainer)entity;
                if (criteria.itemCriteria.isEmpty()) {
                    return List.of();
                }
                UUID uuid = minecart.m_20148_();
                String descriptionId = entity.m_6095_().m_20675_();
                for (ItemStack stack : minecart.m_213659_()) {
                    Item item = stack.m_41720_();
                    if (!criteria.itemCriteriaMap.containsKey(item)) continue;
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ret.add(new ContainerEntityLocationObject(pos.m_7949_(), criterion.slot(), criterion.priority(), descriptionId, item.m_5524_(), uuid));
                }
            }
            return ret;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            if (!options.get(CompassProperties.CONTAINERS).booleanValue() || !TCConfig.ENABLE_BLOCK_CONTAINERS_SEARCH.get().booleanValue()) {
                return false;
            }
            return options.get(CompassProperties.MINECARTS);
        }
    };
    public static final EntityMatcher EGG_MOB_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
            EntityType type = entity.m_6095_();
            for (EntityCriterion criterion : criteria.entityCriteria) {
                if (!criterion.check(type)) continue;
                return List.of(new EntityLocationObject(entity.m_20183_(), criterion.slot(), criterion.priority(), entity.m_7755_().getString(), entity.m_20148_()));
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.MOBS) != false && TCConfig.ENABLE_MOBS_SEARCH.get() != false;
        }
    };
    public static final EntityMatcher VILLAGER_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                MerchantOffers offers = villager.m_6616_();
                boolean buys = options.get(CompassProperties.VILLAGERS_BUYS);
                boolean sells = options.get(CompassProperties.VILLAGERS_SELLS);
                UUID uuid = villager.m_20148_();
                String descriptionId = entity.m_6095_().m_20675_();
                for (MerchantOffer offer : offers) {
                    Item resultItem = offer.m_45368_().m_41720_();
                    Item costAItem = offer.m_45358_().m_41720_();
                    Item costBItem = offer.m_45364_().m_41720_();
                    for (ItemCriterion criterion : criteria.itemCriteria) {
                        if (sells && criterion.check(resultItem)) {
                            ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), descriptionId, resultItem.m_5524_(), uuid));
                        }
                        if (!buys) continue;
                        if (criterion.check(costAItem)) {
                            ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), descriptionId, costAItem.m_5524_(), uuid));
                        }
                        if (!criterion.check(costBItem)) continue;
                        ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), descriptionId, costBItem.m_5524_(), uuid));
                    }
                }
                return ret;
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.VILLAGERS) != false && (options.get(CompassProperties.VILLAGERS_BUYS) != false || options.get(CompassProperties.VILLAGERS_SELLS) != false) && TCConfig.ENABLE_VILLAGERS_SEARCH.get() != false;
        }
    };
    public static final EntityMatcher INVENTORY_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                HashSet<Item> invItems = new HashSet<Item>();
                boolean players = options.get(CompassProperties.INVENTORIES_PLAYERS);
                boolean mobs = options.get(CompassProperties.INVENTORIES_MOBS);
                String descriptionId = entity.m_6095_().m_20675_();
                UUID uuid = entity.m_20148_();
                if (uuid.equals(options.getPlayerUUID())) {
                    return null;
                }
                if (living instanceof Player) {
                    Player player = (Player)living;
                    if (players) {
                        invItems.addAll(player.m_150109_().f_35974_.stream().map(ItemStack::m_41720_).toList());
                        invItems.addAll(player.m_150109_().f_35975_.stream().map(ItemStack::m_41720_).toList());
                        invItems.addAll(player.m_150109_().f_35976_.stream().map(ItemStack::m_41720_).toList());
                        descriptionId = player.m_5446_().getString();
                    }
                } else if (mobs) {
                    for (EquipmentSlot slot : EquipmentSlot.values()) {
                        invItems.add(living.m_6844_(slot).m_41720_());
                    }
                } else {
                    return null;
                }
                for (ItemCriterion criterion : criteria.itemCriteria) {
                    if (!invItems.contains(criterion.item())) continue;
                    ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), descriptionId, criterion.item().m_5524_(), uuid));
                }
                return ret;
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.INVENTORIES) != false && (options.get(CompassProperties.INVENTORIES_MOBS) != false || options.get(CompassProperties.INVENTORIES_PLAYERS) != false);
        }
    };
    public static final EntityMatcher DROP_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof LivingEntity) {
                Set<Item> drops;
                LivingEntity living = (LivingEntity)entity;
                MinecraftServer server = level.m_7654_();
                if (server != null && (drops = LootUtils.getItemsFromLootTable(living.m_5743_(), level)) != null) {
                    for (ItemCriterion criterion : criteria.itemCriteria) {
                        if (!drops.contains(criterion.item())) continue;
                        ret.add(new ContainerEntityLocationObject(pos, criterion.slot(), criterion.priority(), entity.m_6095_().m_20675_(), criterion.item().m_5524_(), entity.m_20148_()));
                    }
                }
                return ret;
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.DROP);
        }
    };
    public static final EntityMatcher ITEM_ENTITY_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                if (criteria.itemCriteria.isEmpty()) {
                    return ret;
                }
                Item item = itemEntity.m_32055_().m_41720_();
                if (criteria.itemCriteriaMap.containsKey(item)) {
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ret.add(new EntityLocationObject(pos.m_7949_(), criterion.slot(), criterion.priority(), item.m_5524_(), itemEntity.m_20148_()));
                }
                return ret;
            }
            return null;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            return options.get(CompassProperties.ITEM_ENTITIES);
        }
    };
    public static final List<BlockMatcher> BLOCK_MATCHERS = List.of(BLOCK_MATCHER, FLUID_MATCHER);
    public static final List<BlockEntityMatcher> BLOCK_ENTITY_MATCHERS = List.of(CONTAINER_MATCHER, SPAWNER_MATCHER, LOOTR_CONTAINER_MATCHER);
    public static final List<EntityMatcher> ENTITY_MATCHERS = List.of(EGG_MOB_MATCHER, INVENTORY_MATCHER, MINECART_MATCHER, VILLAGER_MATCHER, DROP_MATCHER, ITEM_ENTITY_MATCHER, LOOTR_MINECART_MATCHER);
}

