/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.utils;

import com.nine.travelerscompass.mixin.accessor.LootItemAccessor;
import com.nine.travelerscompass.mixin.accessor.LootPoolAccessor;
import com.nine.travelerscompass.platform.accessor.LootTableAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;

public class LootUtils {
    private static final Map<ResourceLocation, Set<Item>> LOOT_CACHE = new HashMap<ResourceLocation, Set<Item>>();

    public static List<LootPool> getPools(LootTable lootTable) {
        return ((LootTableAccessor)lootTable).travelerscompass$getPools();
    }

    public static List<LootPoolEntryContainer> getEntries(LootPool lootPool) {
        return List.of(((LootPoolAccessor)lootPool).travelerscompass$entries());
    }

    public static List<LootItem> getLootItems(LootTable lootTable) {
        ArrayList<LootItem> dropList = new ArrayList<LootItem>();
        LootUtils.getPools(lootTable).forEach(lootPool -> LootUtils.getEntries(lootPool).stream().filter(entry -> entry instanceof LootItem).map(entry -> (LootItem)entry).forEach(dropList::add));
        dropList.removeIf(Objects::isNull);
        return dropList;
    }

    public static Set<Item> getItemsFromLootTable(ResourceLocation location, Level level) {
        if (LOOT_CACHE.containsKey(location)) {
            return LOOT_CACHE.get(location);
        }
        MinecraftServer server = level.m_7654_();
        if (server != null) {
            LootTable lootTable = server.m_278653_().m_278676_(location);
            HashSet dropStackList = new HashSet();
            LootUtils.getLootItems(lootTable).stream().map(lootItem -> ((LootItemAccessor)lootItem).travelerscompass$item()).forEach(dropStackList::add);
            LOOT_CACHE.put(location, dropStackList);
        }
        return LOOT_CACHE.getOrDefault(location, Set.of());
    }
}

