/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.config.filter;

import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.config.filter.FilterReason;
import com.nine.travelerscompass.config.filter.FilterType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class FilterManager {
    private static final Map<Item, FilterReason> FILTER_CACHE = new HashMap<Item, FilterReason>();
    private static final Map<ResourceLocation, FilterReason> FILTER_ENTITIES_CACHE = new HashMap<ResourceLocation, FilterReason>();
    private static FilterData filterData;

    public static FilterReason getFilterReason(EntityType<?> type) {
        if (type == null) {
            return new FilterReason.Allowed();
        }
        ResourceLocation location = BuiltInRegistries.f_256780_.m_7981_(type);
        FilterReason answer = FILTER_ENTITIES_CACHE.get(location);
        if (answer == null) {
            boolean inList = FilterManager.filterData.entitiesFilterSet.contains(location);
            answer = FilterManager.filterData.entitiesFilterType == FilterType.BLACKLIST && inList || FilterManager.filterData.entitiesFilterType == FilterType.WHITELIST && !inList ? new FilterReason.ByEntityType(type) : new FilterReason.Allowed();
            FILTER_ENTITIES_CACHE.put(location, answer);
        }
        return answer;
    }

    public static FilterReason getFilterReason(Item item) {
        if (item == Items.f_41852_) {
            return new FilterReason.Allowed();
        }
        FilterReason answer = FILTER_CACHE.get(item);
        if (answer == null) {
            answer = FilterManager.computeItemFilterReason(item);
            FILTER_CACHE.put(item, answer);
        }
        return answer;
    }

    private static FilterReason computeItemFilterReason(Item item) {
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        String modId = itemId.m_135827_();
        boolean modMatch = FilterManager.filterData.modsFilterSet.contains(modId);
        if (FilterManager.filterData.modsFilterType == FilterType.BLACKLIST && modMatch) {
            return new FilterReason.ByModId(modId);
        }
        if (FilterManager.filterData.modsFilterType == FilterType.WHITELIST && !modMatch) {
            return new FilterReason.ByModId(modId);
        }
        boolean itemMatch = FilterManager.filterData.itemsFilterSet.contains(itemId);
        if (FilterManager.filterData.itemsFilterType == FilterType.BLACKLIST && itemMatch) {
            return new FilterReason.ByItemId(itemId);
        }
        if (FilterManager.filterData.itemsFilterType == FilterType.WHITELIST && !itemMatch) {
            return new FilterReason.ByItemId(itemId);
        }
        boolean hasWhitelistedTag = false;
        for (TagKey<Item> tag : FilterManager.filterData.tagsFilterSet) {
            boolean hasTag = item.m_204114_().m_203656_(tag);
            if (FilterManager.filterData.tagsFilterType == FilterType.BLACKLIST && hasTag) {
                return new FilterReason.ByTag(tag);
            }
            if (!hasTag) continue;
            hasWhitelistedTag = true;
        }
        if (FilterManager.filterData.tagsFilterType == FilterType.WHITELIST && !hasWhitelistedTag) {
            return new FilterReason.ByTag(FilterManager.filterData.tagsFilterSet.iterator().next());
        }
        return new FilterReason.Allowed();
    }

    public static void reload() {
        FILTER_CACHE.clear();
        FILTER_ENTITIES_CACHE.clear();
        filterData = new FilterData(TCConfig.MODS_FILTER_TYPE.get(), new HashSet<String>((Collection)TCConfig.MODS_FILTER.get()), TCConfig.ITEM_TAGS_FILTER_TYPE.get(), TCConfig.ITEM_TAGS_FILTER.get().stream().map(s -> TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(s))).collect(Collectors.toSet()), TCConfig.ITEMS_FILTER_TYPE.get(), TCConfig.ITEMS_FILTER.get().stream().map(ResourceLocation::new).collect(Collectors.toSet()), TCConfig.ENTITIES_FILTER_TYPE.get(), TCConfig.ENTITIES_FILTER.get().stream().map(ResourceLocation::new).collect(Collectors.toSet()));
    }

    public static boolean passesFilters(ItemStack stack) {
        if (stack.m_41619_() || stack.m_41720_() instanceof TravelersCompassItem) {
            return false;
        }
        return FilterManager.getFilterReason(stack.m_41720_()) instanceof FilterReason.Allowed;
    }

    public record FilterData(FilterType modsFilterType, Set<String> modsFilterSet, FilterType tagsFilterType, Set<TagKey<Item>> tagsFilterSet, FilterType itemsFilterType, Set<ResourceLocation> itemsFilterSet, FilterType entitiesFilterType, Set<ResourceLocation> entitiesFilterSet) {
    }
}

