/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.network.packet.s2c;

import com.nine.travelerscompass.config.ConfigSyncManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ConfigSyncPacket {
    private final Map<String, Object> map;

    public ConfigSyncPacket() {
        this.map = new HashMap<String, Object>();
    }

    public ConfigSyncPacket(FriendlyByteBuf buf) {
        this.map = ConfigSyncManager.read(buf);
    }

    public void encode(FriendlyByteBuf buf) {
        ConfigSyncManager.write(buf);
    }

    public static void onMessage(ConfigSyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ConfigSyncManager.SYNCED_VALUES.clear();
            ConfigSyncManager.SYNCED_VALUES.putAll(packet.map);
        }));
        ctx.get().setPacketHandled(true);
    }
}

