/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.location.codec;

import com.nine.travelerscompass.common.search.location.BlockLocationObject;
import com.nine.travelerscompass.common.search.location.ContainerEntityLocationObject;
import com.nine.travelerscompass.common.search.location.ContainerLocationObject;
import com.nine.travelerscompass.common.search.location.EntityLocationObject;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.LootrContainerLocationObject;
import com.nine.travelerscompass.common.search.location.LootrMinecartLocationObject;
import com.nine.travelerscompass.common.search.location.SpawnerLocationObject;
import com.nine.travelerscompass.common.search.location.codec.LocationCodec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class LocationCodecs {
    private static final Map<ResourceLocation, LocationCodec<?>> CODECS = new HashMap();

    private static void register(ResourceLocation id, LocationCodec<?> codec) {
        CODECS.put(id, codec);
    }

    public static void encode(FriendlyByteBuf buf, ILocationObject object) {
        ResourceLocation typeId = object.type();
        buf.writeResourceLocation(typeId);
        LocationCodec<?> codec = CODECS.get(typeId);
        codec.write(buf, object);
    }

    public static ILocationObject read(FriendlyByteBuf buf) {
        ResourceLocation type = buf.readResourceLocation();
        LocationCodec<?> codec = CODECS.get(type);
        if (codec == null) {
            throw new IllegalArgumentException("No such codec: " + String.valueOf(type));
        }
        return codec.read(buf);
    }

    static {
        LocationCodecs.register(EntityLocationObject.TYPE, EntityLocationObject.CODEC);
        LocationCodecs.register(BlockLocationObject.TYPE, BlockLocationObject.CODEC);
        LocationCodecs.register(ContainerLocationObject.TYPE, ContainerLocationObject.CODEC);
        LocationCodecs.register(ContainerEntityLocationObject.TYPE, ContainerEntityLocationObject.CODEC);
        LocationCodecs.register(SpawnerLocationObject.TYPE, SpawnerLocationObject.CODEC);
        LocationCodecs.register(LootrContainerLocationObject.TYPE, LootrContainerLocationObject.CODEC);
        LocationCodecs.register(LootrMinecartLocationObject.TYPE, LootrMinecartLocationObject.CODEC);
    }
}

