/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.network;

import com.nine.travelerscompass.network.packet.PacketHolder;
import com.nine.travelerscompass.network.packet.c2s.C2SPacket;
import com.nine.travelerscompass.network.packet.c2s.CompassDataPacket;
import com.nine.travelerscompass.network.packet.c2s.GhostTargetPacket;
import com.nine.travelerscompass.network.packet.c2s.PausePacket;
import com.nine.travelerscompass.network.packet.c2s.WideSearchPacket;
import com.nine.travelerscompass.network.packet.s2c.CompletePacket;
import com.nine.travelerscompass.network.packet.s2c.ConfigSyncPacket;
import com.nine.travelerscompass.network.packet.s2c.HudDataPacket;
import com.nine.travelerscompass.network.packet.s2c.NetworkSyncPacket;
import com.nine.travelerscompass.network.packet.s2c.S2CPacket;
import com.nine.travelerscompass.network.packet.s2c.SearchProgressSyncPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class TCNetworkManager {
    public static final List<PacketHolder<? extends C2SPacket>> C2S_PACKETS = new ArrayList<PacketHolder<? extends C2SPacket>>();
    public static final List<PacketHolder<? extends S2CPacket>> S2C_PACKETS = new ArrayList<PacketHolder<? extends S2CPacket>>();

    public static void init() {
        TCNetworkManager.addC2SPacket(CompassDataPacket.class, CompassDataPacket.ID, CompassDataPacket.PACKET_CODEC);
        TCNetworkManager.addC2SPacket(GhostTargetPacket.class, GhostTargetPacket.ID, GhostTargetPacket.PACKET_CODEC);
        TCNetworkManager.addC2SPacket(WideSearchPacket.class, WideSearchPacket.ID, WideSearchPacket.PACKET_CODEC);
        TCNetworkManager.addC2SPacket(PausePacket.class, PausePacket.ID, PausePacket.PACKET_CODEC);
        TCNetworkManager.addS2CPacket(ConfigSyncPacket.class, ConfigSyncPacket.ID, ConfigSyncPacket.CODEC);
        TCNetworkManager.addS2CPacket(NetworkSyncPacket.class, NetworkSyncPacket.ID, NetworkSyncPacket.CODEC);
        TCNetworkManager.addS2CPacket(CompletePacket.class, CompletePacket.ID, CompletePacket.CODEC);
        TCNetworkManager.addS2CPacket(SearchProgressSyncPacket.class, SearchProgressSyncPacket.ID, SearchProgressSyncPacket.CODEC);
        TCNetworkManager.addS2CPacket(HudDataPacket.class, HudDataPacket.ID, HudDataPacket.CODEC);
    }

    public static <T extends C2SPacket> void addC2SPacket(Class<T> clazz, CustomPacketPayload.Type<T> id, StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
        C2S_PACKETS.add(new PacketHolder<T>(clazz, id, codec));
    }

    public static <T extends S2CPacket> void addS2CPacket(Class<T> clazz, CustomPacketPayload.Type<T> id, StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
        S2C_PACKETS.add(new PacketHolder<T>(clazz, id, codec));
    }
}

