/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.ContainersButton;
import com.nine.travelerscompass.client.component.button.HudButton;
import com.nine.travelerscompass.client.component.button.InfoButton;
import com.nine.travelerscompass.client.component.button.InventoriesButton;
import com.nine.travelerscompass.client.component.button.RangeButton;
import com.nine.travelerscompass.client.component.button.ResetButton;
import com.nine.travelerscompass.client.component.button.SearchModeButton;
import com.nine.travelerscompass.client.component.button.SettingsButton;
import com.nine.travelerscompass.client.component.button.TabButton;
import com.nine.travelerscompass.client.component.button.Toggleable;
import com.nine.travelerscompass.client.component.button.VillagersButton;
import com.nine.travelerscompass.client.component.button.WarningButton;
import com.nine.travelerscompass.client.component.button.WideSearchButton;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.RangeUtils;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.container.menu.CompassMenu;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.utils.PriorityMode;
import com.nine.travelerscompass.common.utils.SearchState;
import com.nine.travelerscompass.common.utils.TabPage;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.config.cost.SearchCost;
import com.nine.travelerscompass.config.cost.SearchCostHelper;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import com.nine.travelerscompass.network.packet.c2s.PausePacket;
import com.nine.travelerscompass.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CompassScreen
extends AbstractContainerScreen<CompassMenu> {
    private static final ResourceLocation TEXTURE_1 = ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"textures/gui/container/compass_screen_1.png");
    private static final ResourceLocation TEXTURE_2 = ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"textures/gui/container/compass_screen_2.png");
    public static final ResourceLocation PRIORITY_SLOT = ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"textures/gui/priority_slot.png");
    private Player player;
    private ItemStack stack;
    private TabPage tabPage;
    private UUID uuid;
    private int updateTicks;
    private TabButton tabButton1;
    private TabButton tabButton2;
    private WarningButton warningButton;
    private SearchModeButton blocksSearchButton;
    private SearchModeButton mobsSearchButton;
    private ContainersButton containersSearchButton;
    private SearchModeButton fluidsSearchButton;
    private SearchModeButton spawnersSearchButton;
    private SearchModeButton dropsSearchButton;
    private SearchModeButton itemEntitiesSearchButton;
    private InventoriesButton inventoriesSearchButton;
    private VillagersButton villagersSearchButton;
    private SettingsButton pauseButton;
    private WideSearchButton wideSearchButton;
    private InfoButton infoButton;
    private HudButton hudButton;
    private SettingsButton forceChunksLoadButton;
    private SettingsButton targetValidationButton;
    private SettingsButton soundPingButton;
    private SettingsButton attitudeMarkerButton;
    private SettingsButton priorityButton;
    private ResetButton resetButton;
    private RangeButton<Integer> chunksSearchRangeButton;
    private RangeButton<Integer> entitiesSearchRange;
    private RangeButton<Integer> wideSearchRange;

    public CompassScreen(CompassMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageWidth = 177;
        this.imageHeight = 169;
        this.tabPage = TabPage.SEARCH;
    }

    protected void init() {
        super.init();
        if (this.minecraft == null) {
            return;
        }
        this.player = this.minecraft.player;
        if (this.player == null) {
            return;
        }
        ItemStack stack = this.player.getMainHandItem();
        if (!(stack.getItem() instanceof TravelersCompassItem)) {
            return;
        }
        this.stack = stack;
        this.uuid = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
        this.initButtons();
        this.tabPage = CompassProperties.get(stack, CompassProperties.TAB_PAGE);
        this.addTabButtons();
        this.addRenderableWidget((GuiEventListener)this.warningButton);
        switch (this.tabPage) {
            case SEARCH: {
                this.addSearchButtons();
                break;
            }
            case SETTINGS: {
                this.addSettingsButton();
            }
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.tabPage == TabPage.SETTINGS) {
            this.hudButton.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    protected void containerTick() {
        this.fluidsSearchButton.tick();
        ++this.updateTicks;
        if (this.updateTicks % 2 == 0) {
            this.infoButton.refreshTooltip();
            this.wideSearchButton.refreshTooltip();
            this.wideSearchRange.refreshTooltip();
            this.pauseButton.refreshTooltip();
        }
        if (this.updateTicks % 10 == 0) {
            this.warningButton.updateState(this.stack);
            this.updateTicks = 0;
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    private void initButtons() {
        this.blocksSearchButton = new SearchModeButton(this.leftPos + 7, this.topPos + 7, 14, 14, TCConfig.ENABLE_BLOCKS_SEARCH.get(), CompassProperties.BLOCKS, new IconTexture(ClientData.BLOCKS_ACTIVE, 2, 2), new IconTexture(ClientData.BLOCKS_INACTIVE, 2, 2), this.stack);
        this.mobsSearchButton = new SearchModeButton(this.leftPos + 23, this.topPos + 7, 14, 14, TCConfig.ENABLE_MOBS_SEARCH.get(), CompassProperties.MOBS, new IconTexture(ClientData.MOBS_ACTIVE, 2, 2), new IconTexture(ClientData.MOBS_INACTIVE, 2, 2), this.stack);
        this.fluidsSearchButton = new SearchModeButton(this, this.leftPos + 39, this.topPos + 23, 14, 14, TCConfig.ENABLE_FLUIDS_SEARCH.get(), CompassProperties.FLUIDS, new IconTexture(ClientData.FLUIDS_ACTIVE, 2, 2), new IconTexture(ClientData.FLUIDS_INACTIVE, 2, 2), this.stack){
            private int frameIndex = 0;
            private int tickCount = 0;
            final int framesPerTick = 2;
            final int maxFrames = 31;

            @Override
            public void tick() {
                ++this.tickCount;
                if (this.tickCount % 2 == 0) {
                    this.frameIndex = (this.frameIndex + 1) % 31;
                }
            }

            @Override
            public void renderIcon(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                IconTexture icon = this.isToggled() ? this.iconActive : this.iconInactive;
                int yOff = 8 * this.frameIndex;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                TextureData data = icon.textureData().toBuilder().uv(0, yOff).build();
                ClientUtils.renderTexture(graphics, data, this.getX() + icon.xOffset(), this.getY() + icon.yOffset());
            }
        };
        this.spawnersSearchButton = new SearchModeButton(this.leftPos + 23, this.topPos + 23, 14, 14, TCConfig.ENABLE_SPAWNERS_SEARCH.get(), CompassProperties.SPAWNERS, new IconTexture(ClientData.SPAWNERS_ACTIVE, 2, 2), new IconTexture(ClientData.SPAWNERS_INACTIVE, 2, 2), this.stack);
        this.itemEntitiesSearchButton = new SearchModeButton(this.leftPos + 23, this.topPos + 39, 14, 14, TCConfig.ENABLE_ITEM_ENTITIES_SEARCH.get(), CompassProperties.ITEM_ENTITIES, new IconTexture(ClientData.ITEM_ENTITIES_ACTIVE, 2, 2), new IconTexture(ClientData.ITEM_ENTITIES_INACTIVE, 2, 2), this.stack);
        this.dropsSearchButton = new SearchModeButton(this.leftPos + 39, this.topPos + 39, 14, 14, TCConfig.ENABLE_DROPS_SEARCH.get(), CompassProperties.DROP, new IconTexture(ClientData.DROPS_ACTIVE, 1, 2), new IconTexture(ClientData.DROPS_INACTIVE, 1, 2), this.stack);
        this.containersSearchButton = new ContainersButton(this.leftPos + 39, this.topPos + 7, this.stack);
        this.villagersSearchButton = new VillagersButton(this.leftPos + 7, this.topPos + 23, this.stack);
        this.inventoriesSearchButton = new InventoriesButton(this.leftPos + 7, this.topPos + 39, this.stack);
        this.wideSearchButton = new WideSearchButton(this.leftPos + 23, this.topPos + 55, () -> this.stack){

            @Override
            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                CompassScreen.this.pauseButton.updateState();
            }
        };
        this.infoButton = new InfoButton(this.leftPos + 39, this.topPos + 55, 14, 14, () -> this.stack);
        this.pauseButton = new SettingsButton(this.leftPos + 7, this.topPos + 55, 14, 14, CompassProperties.PAUSE, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.RESUME, 2, 2), new IconTexture(ClientData.RESUME_HOVERED, 2, 2), (Component)Component.empty());
            }
            return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.PAUSE, 2, 2), new IconTexture(ClientData.PAUSE_HOVERED, 2, 2), (Component)Component.empty());
        }, () -> this.stack){
            private SearchState cachedState;
            {
                this.cachedState = SearchState.IDLE;
            }

            @Override
            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                ClientData.HUD_DATA_CACHE.computeIfPresent(CompassScreen.this.uuid, (id, hudData) -> {
                    hudData.setPaused((Boolean)this.cachedValue);
                    return hudData;
                });
                ClientData.PROGRESS_DATA_CACHE.remove(CompassScreen.this.uuid);
                Platform.PLATFORM_NETWORK.sendToServer(new PausePacket(CompassScreen.this.uuid));
            }

            @Override
            public void updateState() {
                super.updateState();
                ItemStack stack = (ItemStack)this.supplier.get();
                this.cachedState = CompassProperties.SEARCH_STATE.get(stack);
            }

            @Override
            public void refreshTooltip() {
                ArrayList<Component> list = new ArrayList<Component>();
                boolean paused = (Boolean)this.cachedValue;
                String key = "tooltip.travelerscompass.settings." + (paused ? "resume" : "pause");
                MutableComponent title = Component.translatable((String)key);
                list.add((Component)title);
                if (this.cachedState == SearchState.WIDE_SEARCHING && paused) {
                    list.add((Component)Component.translatable((String)(key + ".warning")).withStyle(ChatFormatting.GRAY));
                }
                if (this.shiftPressed) {
                    list.add((Component)Component.empty().append(ClientUtils.DESC_ARROW).append((Component)Component.translatable((String)(key + ".desc")).withStyle(ChatFormatting.GRAY)));
                }
                this.setTooltip(Tooltip.create((Component)ClientUtils.buildTooltip(list)));
            }
        };
        this.attitudeMarkerButton = new SettingsButton(this.leftPos + 39, this.topPos + 39, 14, 14, CompassProperties.HEIGHT_MARKER, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.ATTITUDE_MARKER_ACTIVE, 2, 2), new IconTexture(ClientData.ATTITUDE_MARKER_ACTIVE_HOVERED, 2, 2), Toggleable.ENABLED);
            }
            return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.ATTITUDE_MARKER_INACTIVE, 2, 2), new IconTexture(ClientData.ATTITUDE_MARKER_INACTIVE_HOVERED, 2, 2), Toggleable.DISABLED);
        }, () -> this.stack);
        this.priorityButton = new SettingsButton(this, this.leftPos + 23, this.topPos + 39, 14, 14, CompassProperties.PRIORITY_MODE, value -> {
            PriorityMode priorityMode = (PriorityMode)((Object)((Object)value));
            return switch (priorityMode) {
                default -> throw new MatchException(null, null);
                case PriorityMode.OFF -> new SettingsButton.DisplayDataHolder(ClientData.PRIORITY_OFF_ICON, ClientData.PRIORITY_OFF_HOVERED_ICON, (Component)Component.empty());
                case PriorityMode.NORMAL -> new SettingsButton.DisplayDataHolder(ClientData.PRIORITY_NORMAL_ICON, ClientData.PRIORITY_NORMAL_HOVERED_ICON, (Component)Component.empty());
                case PriorityMode.INVERTED -> new SettingsButton.DisplayDataHolder(ClientData.PRIORITY_INVERT_ICON, ClientData.PRIORITY_INVERT_HOVERED_ICON, (Component)Component.empty());
            };
        }, () -> this.stack){

            @Override
            public void refreshTooltip() {
                ArrayList<Component> list = new ArrayList<Component>();
                String key = "tooltip.travelerscompass.settings.priority_mode";
                MutableComponent title = Component.translatable((String)key);
                Component state = switch ((PriorityMode)((Object)this.cachedValue)) {
                    default -> throw new MatchException(null, null);
                    case PriorityMode.OFF -> Toggleable.DISABLED;
                    case PriorityMode.NORMAL -> Toggleable.ENABLED;
                    case PriorityMode.INVERTED -> Toggleable.INVERTED;
                };
                list.add((Component)title);
                if (this.shiftPressed) {
                    String descKey = key + ".desc." + ((PriorityMode)((Object)this.cachedValue)).name().toLowerCase();
                    list.add((Component)Component.empty().append(ClientUtils.DESC_ARROW).append((Component)Component.translatable((String)descKey).withStyle(ChatFormatting.GRAY)));
                }
                list.add(state);
                this.setTooltip(Tooltip.create((Component)ClientUtils.buildTooltip(list)));
            }
        };
        this.soundPingButton = new SettingsButton(this.leftPos + 7, this.topPos + 39, 14, 14, CompassProperties.SOUND_PING, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.SOUND_PING_ACTIVE, 3, 3), new IconTexture(ClientData.SOUND_PING_ACTIVE_HOVERED, 3, 3), Toggleable.ENABLED);
            }
            return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.SOUND_PING_INACTIVE, 3, 3), new IconTexture(ClientData.SOUND_PING_INACTIVE_HOVERED, 3, 3), Toggleable.DISABLED);
        }, () -> this.stack);
        this.warningButton = new WarningButton(this.leftPos - 17, this.topPos + 76, 21, 22, this.stack);
        this.hudButton = new HudButton(this.leftPos + 7, this.topPos + 55, () -> this.stack){

            @Override
            public void onPopupExit() {
                CompassScreen.this.warningButton.hidden = false;
                CompassScreen.this.warningButton.updateState(CompassScreen.this.stack);
            }

            @Override
            public void onPopupEnter() {
                CompassScreen.this.warningButton.hidden = true;
                CompassScreen.this.warningButton.setTooltip(Tooltip.create((Component)Component.empty()));
            }
        };
        this.forceChunksLoadButton = new SettingsButton(this.leftPos + 39, this.topPos + 23, 14, 14, CompassProperties.FORCE_CHUNKS_LOAD, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(ClientData.FORCE_LOAD_ACTIVE.icon(2, 2), ClientData.FORCE_LOAD_ACTIVE_HOVERED.icon(2, 2), Toggleable.ENABLED);
            }
            return new SettingsButton.DisplayDataHolder(ClientData.FORCE_LOAD_INACTIVE.icon(2, 2), ClientData.FORCE_LOAD_INACTIVE_HOVERED.icon(2, 2), Toggleable.DISABLED);
        }, () -> this.stack);
        this.targetValidationButton = new SettingsButton(this.leftPos + 23, this.topPos + 55, 14, 14, CompassProperties.TARGET_VALIDATION, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(ClientData.TARGET_VALIDATION_ACTIVE.icon(3, 2), ClientData.TARGET_VALIDATION_ACTIVE_HOVERED.icon(3, 2), Toggleable.ENABLED);
            }
            return new SettingsButton.DisplayDataHolder(ClientData.TARGET_VALIDATION_INACTIVE.icon(3, 2), ClientData.TARGET_VALIDATION_INACTIVE_HOVERED.icon(3, 2), Toggleable.DISABLED);
        }, () -> this.stack);
        this.resetButton = new ResetButton(this.leftPos + 39, this.topPos + 55, buttonDefault -> {
            this.resetSettings();
            this.entitiesSearchRange.updateState();
            this.chunksSearchRangeButton.updateState();
            this.wideSearchRange.updateState();
        });
        this.chunksSearchRangeButton = new RangeButton<Integer>(this.leftPos + 23, this.topPos + 23, 14, 14, 1, TCConfig.BLOCKS_CHUNK_SEARCH_RANGE.get(), RangeUtils.INTEGER, new IconTexture(ClientData.CHUNKS_RANGE, 2, 2), CompassProperties.BLOCK_SEARCH_CHUNK_RANGE, () -> this.stack);
        this.entitiesSearchRange = new RangeButton<Integer>(this.leftPos + 23, this.topPos + 7, 14, 14, 1, TCConfig.ENTITIES_SEARCH_RANGE.get(), RangeUtils.INTEGER, new IconTexture(ClientData.ENTITIES_RANGE, 2, 2), CompassProperties.ENTITIES_SEARCH_RANGE, () -> this.stack);
        this.wideSearchRange = new RangeButton<Integer>(this.leftPos + 39, this.topPos + 7, 14, 14, 1, TCConfig.WIDE_SEARCH_RANGE.get(), RangeUtils.INTEGER, new IconTexture(ClientData.WIDE_SEARCH_RANGE, 2, 2), CompassProperties.WIDE_SEARCH_RANGE, () -> this.stack);
    }

    private void addSearchButtons() {
        this.addRenderableWidget((GuiEventListener)this.blocksSearchButton);
        this.addRenderableWidget((GuiEventListener)this.mobsSearchButton);
        this.addRenderableWidget((GuiEventListener)this.containersSearchButton);
        this.addRenderableWidget((GuiEventListener)this.villagersSearchButton);
        this.addRenderableWidget((GuiEventListener)this.spawnersSearchButton);
        this.addRenderableWidget((GuiEventListener)this.fluidsSearchButton);
        this.addRenderableWidget((GuiEventListener)this.inventoriesSearchButton);
        this.addRenderableWidget((GuiEventListener)this.itemEntitiesSearchButton);
        this.addRenderableWidget((GuiEventListener)this.dropsSearchButton);
        this.addRenderableWidget((GuiEventListener)this.pauseButton);
        this.addRenderableWidget((GuiEventListener)this.wideSearchButton);
        this.addRenderableWidget((GuiEventListener)this.infoButton);
    }

    private void removeSearchButtons() {
        this.removeWidget((GuiEventListener)this.blocksSearchButton);
        this.removeWidget((GuiEventListener)this.mobsSearchButton);
        this.removeWidget((GuiEventListener)this.containersSearchButton);
        this.removeWidget((GuiEventListener)this.villagersSearchButton);
        this.removeWidget((GuiEventListener)this.spawnersSearchButton);
        this.removeWidget((GuiEventListener)this.fluidsSearchButton);
        this.removeWidget((GuiEventListener)this.inventoriesSearchButton);
        this.removeWidget((GuiEventListener)this.itemEntitiesSearchButton);
        this.removeWidget((GuiEventListener)this.dropsSearchButton);
        this.removeWidget((GuiEventListener)this.pauseButton);
        this.removeWidget((GuiEventListener)this.wideSearchButton);
        this.removeWidget((GuiEventListener)this.infoButton);
    }

    private void addSettingsButton() {
        this.addRenderableWidget((GuiEventListener)this.hudButton);
        this.addRenderableWidget((GuiEventListener)this.forceChunksLoadButton);
        this.addRenderableWidget((GuiEventListener)this.targetValidationButton);
        this.addRenderableWidget((GuiEventListener)this.attitudeMarkerButton);
        this.addRenderableWidget((GuiEventListener)this.soundPingButton);
        this.addRenderableWidget((GuiEventListener)this.priorityButton);
        this.addRenderableWidget((GuiEventListener)this.chunksSearchRangeButton);
        this.addRenderableWidget((GuiEventListener)this.entitiesSearchRange);
        this.addRenderableWidget((GuiEventListener)this.wideSearchRange);
        this.addRenderableWidget((GuiEventListener)this.resetButton);
    }

    private void removeSettingsButton() {
        this.removeWidget((GuiEventListener)this.hudButton);
        this.removeWidget((GuiEventListener)this.forceChunksLoadButton);
        this.removeWidget((GuiEventListener)this.targetValidationButton);
        this.removeWidget((GuiEventListener)this.attitudeMarkerButton);
        this.removeWidget((GuiEventListener)this.soundPingButton);
        this.removeWidget((GuiEventListener)this.priorityButton);
        this.removeWidget((GuiEventListener)this.chunksSearchRangeButton);
        this.removeWidget((GuiEventListener)this.entitiesSearchRange);
        this.removeWidget((GuiEventListener)this.wideSearchRange);
        this.removeWidget((GuiEventListener)this.resetButton);
    }

    private void addTabButtons() {
        boolean searchMode = this.tabPage == TabPage.SEARCH;
        this.tabButton1 = (TabButton)this.addRenderableWidget((GuiEventListener)new TabButton(this.leftPos + 130, this.topPos + 8, 26, 24, 6, 4, searchMode, ClientData.SEARCH, button -> {
            if (this.tabPage == TabPage.SETTINGS) {
                this.tabButton1.enabled = true;
                this.tabButton2.enabled = false;
                CompassProperties.TAB_PAGE.sendToServer(this.stack, TabPage.SEARCH);
                this.tabPage = TabPage.SEARCH;
                this.addSearchButtons();
                this.removeSettingsButton();
            }
        }, (Component)Component.translatable((String)"tooltip.travelerscompass.search")));
        this.tabButton2 = new TabButton(this.leftPos + 130, this.topPos + 42, 26, 24, 6, 4, !searchMode, ClientData.SETTINGS, button -> {
            if (this.tabPage == TabPage.SEARCH) {
                this.tabButton1.enabled = false;
                this.tabButton2.enabled = true;
                CompassProperties.TAB_PAGE.sendToServer(this.stack, TabPage.SETTINGS);
                this.tabPage = TabPage.SETTINGS;
                this.addSettingsButton();
                this.removeSearchButtons();
            }
        }, (Component)Component.translatable((String)"tooltip.travelerscompass.settings"));
        this.addRenderableWidget((GuiEventListener)this.tabButton1);
        this.addRenderableWidget((GuiEventListener)this.tabButton2);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.minecraft != null && this.minecraft.player != null && this.minecraft.player.getMainHandItem().getItem() instanceof TravelersCompassItem) {
            this.stack = this.minecraft.player.getMainHandItem();
        }
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (!TCConfig.SEARCH_REQUIRES_XP.get().booleanValue()) {
            return;
        }
        Slot slot = this.hoveredSlot;
        if (slot != null && slot.container instanceof CompassContainer) {
            Item carried = ((CompassMenu)this.getMenu()).getCarried().getItem();
            SearchCost sc = SearchCostHelper.getCost(carried);
            FilterReason reason = FilterManager.getFilterReason(carried);
            if (reason instanceof FilterReason.Allowed) {
                if (!sc.isFree() && !this.player.isCreative()) {
                    ArrayList<MutableComponent> extra = new ArrayList<MutableComponent>();
                    extra.add(sc.reqAsComponent().withStyle(sc.meetsRequirement(this.player.experienceLevel) ? ChatFormatting.GRAY : ChatFormatting.RED));
                    extra.add(sc.costAsComponent().withStyle(ChatFormatting.GRAY));
                    guiGraphics.renderComponentTooltip(this.font, extra, mouseX, mouseY);
                }
            } else {
                guiGraphics.renderTooltip(this.font, ClientUtils.formatReason(reason), mouseX, mouseY);
            }
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && this.stack != null) {
            graphics.blit(this.tabPage.equals((Object)TabPage.SEARCH) ? TEXTURE_1 : TEXTURE_2, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
            for (int i : CompassProperties.get(this.stack, CompassProperties.PRIORITY_SLOTS)) {
                int j = i > 2 ? 1 : 0;
                j = i > 5 ? 2 : j;
                int c = i > 2 ? i - 3 : i;
                c = i > 5 ? i - 6 : c;
                graphics.blit(PRIORITY_SLOT, this.leftPos + 72 + c * 18, this.topPos + 10 + j * 18, 0.0f, 0.0f, 18, 18, 18, 18);
            }
        }
    }

    private void resetSettings() {
        List<DataStorage<Integer>> toReset = List.of(CompassProperties.TARGET_VALIDATION, CompassProperties.SOUND_PING, CompassProperties.HEIGHT_MARKER, CompassProperties.HUD_RENDER_MODE, CompassProperties.PRIORITY_MODE, CompassProperties.FORCE_CHUNKS_LOAD, CompassProperties.ENTITIES_SEARCH_RANGE, CompassProperties.BLOCK_SEARCH_CHUNK_RANGE, CompassProperties.WIDE_SEARCH_RANGE);
        for (DataStorage<Integer> data : toReset) {
            CompassProperties.putDefaultToServer(this.stack, data);
        }
        this.targetValidationButton.updateState();
        this.soundPingButton.updateState();
        this.attitudeMarkerButton.updateState();
        this.priorityButton.updateState();
        this.forceChunksLoadButton.updateState();
        this.entitiesSearchRange.updateState();
        this.chunksSearchRangeButton.updateState();
        this.wideSearchRange.updateState();
        this.hudButton.resetSettings(this.stack);
        this.hudButton.updateState();
    }

    public int leftPos() {
        return this.leftPos;
    }

    public int topPos() {
        return this.topPos;
    }
}

