/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.compat.jade;

import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.config.cost.SearchCost;
import com.nine.travelerscompass.config.cost.SearchCostHelper;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum BlocksComponentProvider implements IBlockComponentProvider
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig pluginConfig) {
        Block block = blockAccessor.getBlock();
        Player player = blockAccessor.getPlayer();
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof TravelersCompassItem)) {
            return;
        }
        FilterReason reason = FilterManager.getFilterReason(block.asItem());
        if (reason instanceof FilterReason.Allowed) {
            boolean reqOk;
            CompassContainer compassContainer = CompassContainer.container(stack);
            if (!compassContainer.getList().contains(block.asItem())) {
                tooltip.add((Component)Component.translatable((String)"waila.travelerscompass.info.block").withStyle(ChatFormatting.GRAY));
            }
            if (!TCConfig.SEARCH_REQUIRES_XP.get().booleanValue()) {
                return;
            }
            SearchCost sc = SearchCostHelper.getCost(block.asItem());
            if (sc.isFree()) {
                return;
            }
            boolean bl = reqOk = sc.meetsRequirement(player.experienceLevel) || player.isCreative();
            if (!sc.meetsRequirement(player.experienceLevel)) {
                tooltip.add((Component)sc.reqAsComponent().withStyle(ChatFormatting.RED));
            }
            if (sc.costLevel() > 0) {
                tooltip.add((Component)sc.costAsComponent().withStyle(reqOk ? ChatFormatting.GRAY : ChatFormatting.RED));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"waila.travelerscompass.forbidden_block").withStyle(ChatFormatting.RED));
        }
    }

    public ResourceLocation getUid() {
        return ResourceLocation.parse((String)"travelerscompass");
    }
}

