/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.network.packet.s2c;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import com.nine.travelerscompass.network.packet.s2c.S2CPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record NetworkSyncPacket(Map<Byte, String> map) implements S2CPacket
{
    public static final CustomPacketPayload.Type<NetworkSyncPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"network_sync_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, NetworkSyncPacket> CODEC = StreamCodec.ofMember(NetworkSyncPacket::encode, NetworkSyncPacket::decode);

    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.map.size());
        for (Map.Entry<Byte, String> el : this.map.entrySet()) {
            buf.writeByte(el.getKey().byteValue());
            buf.writeUtf(el.getValue());
        }
    }

    public static NetworkSyncPacket decode(RegistryFriendlyByteBuf buf) {
        HashMap<Byte, String> map = new HashMap<Byte, String>();
        int size = buf.readVarInt();
        for (int i = 0; i < size; ++i) {
            map.put(buf.readByte(), buf.readUtf());
        }
        return new NetworkSyncPacket(map);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void handle() {
        for (Map.Entry<Byte, String> el : this.map.entrySet()) {
            byte id = el.getKey();
            String value = el.getValue();
            DataStorage<?> current = CompassProperties.NETWORK_REGISTRY.get(id);
            DataStorage<?> correct = CompassProperties.REGISTRY.get(value);
            if (current == null || correct == null || Objects.equals(current.id(), value)) continue;
            CompassProperties.NETWORK_REGISTRY.put(id, correct);
        }
    }
}

